/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.trusted.web.flow;

import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.trusted.web.flow.BaseNonInteractiveCredentialsActionTests;
import org.apereo.cas.adaptors.trusted.web.flow.PrincipalFromRequestExtractorAction;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.message.DefaultMessageContext;
import org.springframework.context.MessageSource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowActions")
@TestPropertySource(properties={"cas.authn.adaptive.policy.reject-ip-addresses=1.2.3.4"})
public class PrincipalFromRequestHeaderNonInteractiveCredentialsActionTests
extends BaseNonInteractiveCredentialsActionTests {
    @Autowired
    @Qualifier(value="principalFromRemoteHeaderPrincipalAction")
    private PrincipalFromRequestExtractorAction action;

    @Test
    public void verifyRemoteUserExists() throws Exception {
        MockRequestContext context = new MockRequestContext();
        DefaultMessageContext messageContext = (DefaultMessageContext)context.getMessageContext();
        messageContext.setMessageSource((MessageSource)Mockito.mock(MessageSource.class));
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)"casuser");
        request.setUserPrincipal(principal);
        Assertions.assertEquals((Object)"success", (Object)this.action.execute((RequestContext)context).getId());
        request.setRemoteUser("test");
        Assertions.assertEquals((Object)"success", (Object)this.action.execute((RequestContext)context).getId());
        request.addHeader("principal", (Object)"casuser");
        Assertions.assertEquals((Object)"success", (Object)this.action.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyError() throws Exception {
        MockRequestContext context = new MockRequestContext();
        DefaultMessageContext messageContext = (DefaultMessageContext)context.getMessageContext();
        messageContext.setMessageSource((MessageSource)Mockito.mock(MessageSource.class));
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        request.setRemoteUser("xyz");
        request.addParameter(this.casProperties.getAuthn().getMfa().getTriggers().getHttp().getRequestParameter(), "mfa-whatever");
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertEquals((Object)"authenticationFailure", (Object)this.action.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyAdaptiveError() throws Exception {
        MockRequestContext context = new MockRequestContext();
        DefaultMessageContext messageContext = (DefaultMessageContext)context.getMessageContext();
        messageContext.setMessageSource((MessageSource)Mockito.mock(MessageSource.class));
        MockHttpServletRequest request = new MockHttpServletRequest();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        request.setRemoteUser("xyz");
        request.setRemoteAddr("1.2.3.4");
        request.setLocalAddr("1.2.3.4");
        request.addHeader("user-agent", (Object)"FIREFOX");
        request.addParameter("geolocation", "1000,1000,1000,1000");
        ClientInfoHolder.setClientInfo((ClientInfo)new ClientInfo((HttpServletRequest)request));
        request.addParameter(this.casProperties.getAuthn().getMfa().getTriggers().getHttp().getRequestParameter(), "mfa-whatever");
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)RegisteredServiceTestUtils.getService());
        Assertions.assertEquals((Object)"authenticationFailure", (Object)this.action.execute((RequestContext)context).getId());
    }
}

