/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.couchdb.u2f;

import java.time.LocalDate;
import java.util.List;
import org.apereo.cas.couchdb.u2f.CouchDbU2FDeviceRegistration;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.support.CouchDbRepositorySupport;
import org.ektorp.support.GenerateView;
import org.ektorp.support.UpdateHandler;
import org.ektorp.support.View;

@View(name="all", map="function(doc) { if(doc.record && doc.createdDate && doc.username) { emit(doc._id, doc) } }")
public class U2FDeviceRegistrationCouchDbRepository
extends CouchDbRepositorySupport<CouchDbU2FDeviceRegistration> {
    private final CouchDbInstance couchDbInstance;

    public U2FDeviceRegistrationCouchDbRepository(CouchDbConnector couchDbConnector, CouchDbInstance couchDbInstance, boolean createIfNotExists) {
        super(CouchDbU2FDeviceRegistration.class, couchDbConnector, createIfNotExists);
        this.couchDbInstance = couchDbInstance;
    }

    @GenerateView
    public List<CouchDbU2FDeviceRegistration> findByUsername(String username) {
        return this.queryView("by_username", username);
    }

    @View(name="by_createdDate", map="function(doc) { if(doc.record && doc.createdDate && doc.username) { emit(doc.createdDate, doc) } }")
    public List<CouchDbU2FDeviceRegistration> findByDateBefore(LocalDate expirationDate) {
        return this.db.queryView(this.createQuery("by_createdDate").endKey((Object)expirationDate), CouchDbU2FDeviceRegistration.class);
    }

    @UpdateHandler(name="delete_record", file="delete.js")
    public void deleteRecord(CouchDbU2FDeviceRegistration record) {
        this.db.callUpdateHandler(this.stdDesignDocumentId, "delete_record", record.getCid(), null);
    }

    public void deleteAll() {
        this.couchDbInstance.deleteDatabase(this.db.getDatabaseName());
        this.couchDbInstance.createDatabaseIfNotExists(this.db.getDatabaseName());
        this.initStandardDesignDocument();
    }
}

