/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.couchdb.u2f.CouchDbU2FDeviceRegistration;
import org.apereo.cas.couchdb.u2f.U2FDeviceRegistrationCouchDbRepository;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class U2FCouchDbDeviceRepository
extends BaseU2FDeviceRepository
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FCouchDbDeviceRepository.class);
    private final U2FDeviceRegistrationCouchDbRepository couchDb;
    private final long expirationTime;
    private final TimeUnit expirationTimeUnit;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "U2FCouchDbDeviceRepositoryThread"));
    private boolean asynchronous;

    public U2FCouchDbDeviceRepository(LoadingCache<String, String> requestStorage, U2FDeviceRegistrationCouchDbRepository couchDb, long expirationTime, TimeUnit expirationTimeUnit, boolean asynchronous, CipherExecutor<Serializable, String> cipherExecutor) {
        super(requestStorage, cipherExecutor);
        this.couchDb = couchDb;
        this.expirationTime = expirationTime;
        this.expirationTimeUnit = expirationTimeUnit;
        this.asynchronous = asynchronous;
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices() {
        return this.couchDb.getAll().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<U2FDeviceRegistration> getRegisteredDevices(String username) {
        return this.couchDb.findByUsername(username).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration registration) {
        CouchDbU2FDeviceRegistration couchDbDevice = new CouchDbU2FDeviceRegistration(registration);
        if (this.asynchronous) {
            this.executorService.execute(() -> this.couchDb.add((Object)couchDbDevice));
        } else {
            this.couchDb.add((Object)couchDbDevice);
        }
        return couchDbDevice;
    }

    public boolean isDeviceRegisteredFor(String username) {
        return !this.getRegisteredDevices(username).isEmpty();
    }

    public void clean() {
        LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
        LOGGER.debug("Cleaning up expired U2F device registrations based on expiration date [{}]", (Object)expirationDate);
        if (this.asynchronous) {
            this.executorService.execute(() -> this.couchDb.findByDateBefore(expirationDate).forEach(this.couchDb::deleteRecord));
        } else {
            this.couchDb.findByDateBefore(expirationDate).forEach(this.couchDb::deleteRecord);
        }
    }

    public void removeAll() {
        if (this.asynchronous) {
            this.executorService.execute(this.couchDb::deleteAll);
        } else {
            this.couchDb.deleteAll();
        }
    }

    public void deleteRegisteredDevice(U2FDeviceRegistration registration) {
        CouchDbU2FDeviceRegistration couchDbDevice = (CouchDbU2FDeviceRegistration)((Object)CouchDbU2FDeviceRegistration.class.cast(registration));
        if (this.asynchronous) {
            this.executorService.execute(() -> this.couchDb.deleteRecord(couchDbDevice));
        } else {
            this.couchDb.deleteRecord(couchDbDevice);
        }
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Generated
    public U2FDeviceRegistrationCouchDbRepository getCouchDb() {
        return this.couchDb;
    }

    @Generated
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public TimeUnit getExpirationTimeUnit() {
        return this.expirationTimeUnit;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Generated
    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    @Generated
    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }
}

