/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import org.apereo.cas.adaptors.u2f.storage.U2FCouchDbDeviceRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.couchdb.BaseCouchDbProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FCouchDbMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.couchdb.core.CouchDbConnectorFactory;
import org.apereo.cas.couchdb.u2f.U2FDeviceRegistrationCouchDbRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.ektorp.impl.ObjectMapperFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="couchDbU2fConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FCouchDbConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="u2fRegistrationRecordCipherExecutor")
    private CipherExecutor<Serializable, String> u2fRegistrationRecordCipherExecutor;
    @Autowired
    @Qualifier(value="defaultObjectMapperFactory")
    private ObjectProvider<ObjectMapperFactory> objectMapperFactory;

    @ConditionalOnMissingBean(name={"u2fCouchDbFactory"})
    @Bean
    @RefreshScope
    public CouchDbConnectorFactory u2fCouchDbFactory() {
        return new CouchDbConnectorFactory((BaseCouchDbProperties)this.casProperties.getAuthn().getMfa().getU2f().getCouchDb(), (ObjectMapperFactory)this.objectMapperFactory.getObject());
    }

    @ConditionalOnMissingBean(name={"couchDbU2fDeviceRegistrationRepository"})
    @Bean
    @RefreshScope
    public U2FDeviceRegistrationCouchDbRepository couchDbU2fDeviceRegistrationRepository(@Qualifier(value="u2fCouchDbFactory") CouchDbConnectorFactory u2fCouchDbFactory) {
        U2FCouchDbMultifactorProperties couchDb = this.casProperties.getAuthn().getMfa().getU2f().getCouchDb();
        return new U2FDeviceRegistrationCouchDbRepository(u2fCouchDbFactory.getCouchDbConnector(), u2fCouchDbFactory.getCouchDbInstance(), couchDb.isCreateIfNotExists());
    }

    @ConditionalOnMissingBean(name={"couchDbU2fDeviceRepository"})
    @Bean
    @RefreshScope
    public U2FCouchDbDeviceRepository u2fDeviceRepository(@Qualifier(value="couchDbU2fDeviceRegistrationRepository") U2FDeviceRegistrationCouchDbRepository couchDbU2fDeviceRegistrationRepository) {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        U2FCouchDbMultifactorProperties couchDb = u2f.getCouchDb();
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getExpireRegistrations(), u2f.getExpireRegistrationsTimeUnit()).build(key -> "");
        return new U2FCouchDbDeviceRepository((LoadingCache<String, String>)requestStorage, couchDbU2fDeviceRegistrationRepository, u2f.getExpireRegistrations(), u2f.getExpireDevicesTimeUnit(), couchDb.isAsynchronous(), this.u2fRegistrationRecordCipherExecutor);
    }
}

