/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.yubico.u2f.data.DeviceRegistration;
import java.security.cert.X509Certificate;
import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.util.crypto.CertUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.test.annotation.DirtiesContext;

@DirtiesContext
public abstract class AbstractU2FDeviceRepositoryTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractU2FDeviceRepositoryTests.class);

    @Test
    public void verifyDeviceSaved() {
        try {
            this.registerDevices();
            U2FDeviceRepository deviceRepository = this.getDeviceRepository();
            Collection devs = deviceRepository.getRegisteredDevices("casuser");
            this.verifyDevicesAvailable(devs);
        }
        catch (Exception e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    protected void registerDevices() {
        X509Certificate cert = CertUtils.readCertificate((InputStreamSource)new ClassPathResource("cert.crt"));
        DeviceRegistration r1 = new DeviceRegistration("keyhandle11", "publickey1", cert, 1L);
        DeviceRegistration r2 = new DeviceRegistration("keyhandle22", "publickey1", cert, 2L);
        U2FDeviceRepository deviceRepository = this.getDeviceRepository();
        deviceRepository.registerDevice("casuser", r1);
        deviceRepository.registerDevice("casuser", r2);
    }

    protected void verifyDevicesAvailable(Collection<DeviceRegistration> devs) {
        Assert.assertEquals((long)2L, (long)devs.size());
    }

    protected abstract U2FDeviceRepository getDeviceRepository();
}

