/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yubico.u2f.data.DeviceRegistration;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.AbstractU2FDeviceRepositoryTests;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.config.U2FConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={U2FConfiguration.class, AopAutoConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@TestPropertySource(properties={"cas.authn.mfa.u2f.rest.url=http://localhost:9196"})
public class U2FRestResourceDeviceRepositoryTests
extends AbstractU2FDeviceRepositoryTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FRestResourceDeviceRepositoryTests.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY).findAndRegisterModules();
    private static MockWebServer WEB_SERVER;
    @Autowired
    @Qualifier(value="u2fDeviceRepository")
    private U2FDeviceRepository u2fDeviceRepository;

    @Override
    protected U2FDeviceRepository getDeviceRepository() {
        return this.u2fDeviceRepository;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        HashMap<String, List> devices = new HashMap<String, List>();
        DeviceRegistration reg = new DeviceRegistration("123456", "bjsdghj3b", "njsdkhjdfjh45", 1L, false);
        U2FDeviceRegistration device1 = new U2FDeviceRegistration(2000L, "casuser", reg.toJson(), LocalDate.now());
        U2FDeviceRegistration device2 = new U2FDeviceRegistration(1000L, "casuser", reg.toJson(), LocalDate.now());
        devices.put("devices", CollectionUtils.wrapList((Object[])new U2FDeviceRegistration[]{device1, device2}));
        String data = MAPPER.writeValueAsString(devices);
        WEB_SERVER = new MockWebServer(9196, data);
        WEB_SERVER.start();
    }

    @AfterClass
    public static void afterClass() {
        WEB_SERVER.close();
    }

    @Override
    protected void registerDevices() {
    }
}

