/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.List;
import org.apereo.cas.BaseCoreWsSecurityIdentityProviderConfigurationTests;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.SecurityTokenServiceTokenFetcher;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Tag(value="WSFederation")
public class DefaultSecurityTokenServiceTokenFetcherTests
extends BaseCoreWsSecurityIdentityProviderConfigurationTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="securityTokenServiceTokenFetcher")
    private SecurityTokenServiceTokenFetcher securityTokenServiceTokenFetcher;

    @Test
    public void verifySecurityPopulator() {
        String realm = this.casProperties.getAuthn().getWsfedIdp().getIdp().getRealm();
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm(realm);
        registeredService.setServiceId("http://app.example.org/wsfed-idp");
        registeredService.setName("WSFED App");
        registeredService.setId(100L);
        registeredService.setAppliesTo(realm);
        registeredService.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        this.servicesManager.save((RegisteredService)registeredService);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)("http://example.org?wreply=" + registeredService.getServiceId() + "&wtrealm=" + realm));
        service.getAttributes().put("wreply", List.of(registeredService.getServiceId()));
        Assertions.assertThrows(AuthenticationException.class, () -> this.securityTokenServiceTokenFetcher.fetch((Service)service, "test"));
    }
}

