/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.BaseCoreWsSecurityIdentityProviderConfigurationTests;
import org.apereo.cas.authentication.SecurityTokenServiceClientBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Tag(value="WSFederation")
public class SecurityTokenServiceClientBuilderTests
extends BaseCoreWsSecurityIdentityProviderConfigurationTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="securityTokenServiceClientBuilder")
    private SecurityTokenServiceClientBuilder securityTokenServiceClientBuilder;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @BeforeEach
    public void beforeEach() {
        this.servicesManager.deleteAll();
    }

    @Test
    public void verifyClientSecurityRequest() {
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        Assertions.assertNotNull((Object)this.securityTokenServiceClientBuilder.buildClientForSecurityTokenRequests(registeredService));
        Bus bus = BusFactory.getDefaultBus();
        HTTPConduitConfigurer extension = (HTTPConduitConfigurer)bus.getExtension(HTTPConduitConfigurer.class);
        Assertions.assertNotNull((Object)extension);
        HTTPConduit conduit = (HTTPConduit)Mockito.mock(HTTPConduit.class);
        AtomicBoolean configured = new AtomicBoolean();
        ((HTTPConduit)Mockito.doAnswer(invocationOnMock -> {
            configured.set(true);
            return null;
        }).when((Object)conduit)).setTlsClientParameters((TLSClientParameters)Mockito.any());
        extension.configure("mockBean", "https://localhost:8443/cas/", conduit);
        Assertions.assertTrue((boolean)configured.get());
    }

    @Test
    public void verifyRelyingPartyTokenResponses() {
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        SecurityToken token = new SecurityToken(UUID.randomUUID().toString());
        Assertions.assertNotNull((Object)this.securityTokenServiceClientBuilder.buildClientForRelyingPartyTokenResponses(token, registeredService));
    }

    private WSFederationRegisteredService getWsFederationRegisteredService() {
        String realm = this.casProperties.getAuthn().getWsfedIdp().getIdp().getRealm();
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm(realm);
        registeredService.setServiceId("http://app.example.org/wsfed-idp");
        registeredService.setName(UUID.randomUUID().toString());
        registeredService.setId(RandomUtils.nextLong());
        registeredService.setPolicyNamespace("policy-namespace");
        registeredService.setAppliesTo(realm);
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }
}

