/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.BaseCoreWsSecurityIdentityProviderConfigurationTests;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.SecurityTokenServiceClient;
import org.apereo.cas.authentication.SecurityTokenServiceClientBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ws.idp.WSFederationClaims;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.apereo.cas.ws.idp.services.WSFederationRelyingPartyTokenProducer;
import org.apereo.cas.ws.idp.web.WSFederationRequest;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.validation.Assertion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.TestPropertySource;
import org.w3c.dom.Element;

@Tag(value="WSFederation")
@Import(value={DefaultRelyingPartyTokenProducerTestConfiguration.class})
@TestPropertySource(properties={"cas.authn.wsfed-idp.sts.custom-claims=my-custom-claim,second-custom-claim"})
public class DefaultRelyingPartyTokenProducerTests
extends BaseCoreWsSecurityIdentityProviderConfigurationTests {
    @Autowired
    @Qualifier(value="wsFederationRelyingPartyTokenProducer")
    private WSFederationRelyingPartyTokenProducer wsFederationRelyingPartyTokenProducer;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @Test
    public void verifyFailsOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm("CAS");
        registeredService.setServiceId("http://app.example.org/wsfed-idp");
        registeredService.setName("WSFED App");
        registeredService.setId(100L);
        registeredService.setAppliesTo("FatalError");
        registeredService.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        this.servicesManager.save((RegisteredService)registeredService);
        AttributePrincipalImpl principal = new AttributePrincipalImpl("casuser", CoreAuthenticationTestUtils.getAttributes());
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getPrincipal()).thenReturn((Object)principal);
        SecurityToken securityToken = (SecurityToken)Mockito.mock(SecurityToken.class);
        Assertions.assertThrows(SoapFault.class, () -> this.wsFederationRelyingPartyTokenProducer.produce(securityToken, registeredService, WSFederationRequest.of((HttpServletRequest)request), (HttpServletRequest)request, assertion));
    }

    @Test
    public void verifyRequestFailsOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm("CAS");
        registeredService.setServiceId("http://app.example.org/wsfed-idp");
        registeredService.setName("WSFED App");
        registeredService.setId(100L);
        registeredService.setAppliesTo("RequestFailed");
        registeredService.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        this.servicesManager.save((RegisteredService)registeredService);
        AttributePrincipalImpl principal = new AttributePrincipalImpl("casuser", CoreAuthenticationTestUtils.getAttributes());
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getPrincipal()).thenReturn((Object)principal);
        SecurityToken securityToken = (SecurityToken)Mockito.mock(SecurityToken.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.wsFederationRelyingPartyTokenProducer.produce(securityToken, registeredService, WSFederationRequest.of((HttpServletRequest)request), (HttpServletRequest)request, assertion));
    }

    @Test
    public void verifyOperation() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm("CAS");
        registeredService.setServiceId("http://app.example.org/wsfed-idp");
        registeredService.setName("WSFED App");
        registeredService.setId(100L);
        registeredService.setAppliesTo("CAS");
        registeredService.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        this.servicesManager.save((RegisteredService)registeredService);
        Map attributes = CoreAuthenticationTestUtils.getAttributes();
        attributes.put(WSFederationClaims.COMMON_NAME.name(), List.of("common-name-wsfed"));
        attributes.put(WSFederationClaims.GIVEN_NAME.getUri(), List.of("common-name-wsfed"));
        attributes.put("my-custom-claim", List.of("custom-claim-value"));
        AttributePrincipalImpl principal = new AttributePrincipalImpl("casuser", attributes);
        Assertion assertion = (Assertion)Mockito.mock(Assertion.class);
        Mockito.when((Object)assertion.getPrincipal()).thenReturn((Object)principal);
        SecurityToken securityToken = (SecurityToken)Mockito.mock(SecurityToken.class);
        String result = this.wsFederationRelyingPartyTokenProducer.produce(securityToken, registeredService, WSFederationRequest.of((HttpServletRequest)request), (HttpServletRequest)request, assertion);
        Assertions.assertEquals((Object)"<SecurityToken id=\"abcdefgh123456\"/>", (Object)result);
    }

    @TestConfiguration(value="DefaultRelyingPartyTokenProducerTestConfiguration")
    public static class DefaultRelyingPartyTokenProducerTestConfiguration {
        @Bean
        public SecurityTokenServiceClientBuilder securityTokenServiceClientBuilder() throws Exception {
            SecurityTokenServiceClient client = (SecurityTokenServiceClient)Mockito.mock(SecurityTokenServiceClient.class);
            SecurityTokenServiceClientBuilder builder = (SecurityTokenServiceClientBuilder)Mockito.mock(SecurityTokenServiceClientBuilder.class);
            Mockito.when((Object)builder.buildClientForRelyingPartyTokenResponses((SecurityToken)Mockito.any(SecurityToken.class), (WSFederationRegisteredService)Mockito.any(WSFederationRegisteredService.class))).thenReturn((Object)client);
            Mockito.when((Object)client.getProperties()).thenReturn(new HashMap(0));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Element elementResponse = db.newDocument().createElement("SecurityToken");
            elementResponse.setAttribute("id", "abcdefgh123456");
            Mockito.when((Object)client.requestSecurityTokenResponse((String)ArgumentMatchers.eq((Object)"CAS"))).thenReturn((Object)elementResponse);
            Mockito.when((Object)client.requestSecurityTokenResponse((String)ArgumentMatchers.eq((Object)"FatalError"))).thenThrow(new Throwable[]{new SoapFault("error", SoapFault.FAULT_CODE_SERVER)});
            Mockito.when((Object)client.requestSecurityTokenResponse((String)ArgumentMatchers.eq((Object)"RequestFailed"))).thenThrow(new Throwable[]{new SoapFault("error", new QName("RequestFailed"))});
            return builder;
        }
    }
}

