/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.services;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.BaseCoreWsSecurityIdentityProviderConfigurationTests;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.PartialRegexRegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Tag(value="WSFederation")
public class WsFederationServicesManagerRegisteredServiceLocatorTests
extends BaseCoreWsSecurityIdentityProviderConfigurationTests {
    @Autowired
    @Qualifier(value="wsFederationServicesManagerRegisteredServiceLocator")
    private ServicesManagerRegisteredServiceLocator wsFederationServicesManagerRegisteredServiceLocator;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @BeforeEach
    public void setup() {
        this.servicesManager.deleteAll();
    }

    @Test
    public void verifyOperation() {
        Assertions.assertNotNull((Object)this.wsFederationServicesManagerRegisteredServiceLocator);
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)this.wsFederationServicesManagerRegisteredServiceLocator.getOrder());
        WSFederationRegisteredService registeredService = WsFederationServicesManagerRegisteredServiceLocatorTests.getWsFederationRegisteredService("http://app.example.org/wsfed.*", "CAS");
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService("http://app.example.org/wsfed-whatever");
        service.setAttributes(Map.of("wreply", List.of("http://app.example.org/wsfed")));
        RegisteredService result = this.wsFederationServicesManagerRegisteredServiceLocator.locate(List.of(registeredService), (Service)service);
        Assertions.assertNotNull((Object)result);
    }

    private static WSFederationRegisteredService getWsFederationRegisteredService(String serviceId, String realm) {
        WSFederationRegisteredService service = new WSFederationRegisteredService();
        service.setRealm(realm);
        service.setServiceId(serviceId);
        service.setName("WSFED App");
        service.setId((long)RandomUtils.nextInt());
        service.setAppliesTo("Example");
        service.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        service.setMatchingStrategy((RegisteredServiceMatchingStrategy)new PartialRegexRegisteredServiceMatchingStrategy());
        return service;
    }

    @Test
    public void verifyWithCallback() throws Exception {
        String callbackUrl = "http://localhost:8443/cas/ws/idp/federationcallback";
        AbstractRegisteredService service0 = RegisteredServiceTestUtils.getRegisteredService((String)"http://localhost:8443/cas/ws/idp/federationcallback.*");
        service0.setEvaluationOrder(0);
        WSFederationRegisteredService service1 = WsFederationServicesManagerRegisteredServiceLocatorTests.getWsFederationRegisteredService("application1", "CAS");
        service1.setEvaluationOrder(100);
        WSFederationRegisteredService service2 = WsFederationServicesManagerRegisteredServiceLocatorTests.getWsFederationRegisteredService(".*", "CAS");
        service2.setEvaluationOrder(1000);
        List candidateServices = CollectionUtils.wrapList((Object[])new AbstractRegisteredService[]{service0, service1, service2});
        this.servicesManager.save(candidateServices.toArray(new RegisteredService[0]));
        Collections.sort(candidateServices);
        URIBuilder url = new URIBuilder("http://localhost:8443/cas/ws/idp/federationcallback?wtrealm=CAS&wreply=application1");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("http://localhost:8443/cas/ws/idp/federationcallback");
        url.getQueryParams().forEach(param -> request.addParameter(param.getName(), param.getValue()));
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
        WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(url.toString());
        RegisteredService result = this.servicesManager.findServiceBy((Service)service);
        Assertions.assertEquals((Object)service1, (Object)result);
    }
}

