/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.web;

import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.BaseCoreWsSecurityIdentityProviderConfigurationTests;
import org.apereo.cas.authentication.SecurityTokenServiceTokenFetcher;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockServiceTicket;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.SecurityTokenTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.apereo.cas.ws.idp.services.WSFederationRelyingPartyTokenProducer;
import org.apereo.cas.ws.idp.web.WSFederationRequest;
import org.apereo.cas.ws.idp.web.WSFederationValidateRequestCallbackController;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.servlet.ModelAndView;

@Tag(value="WSFederation")
@TestPropertySource(properties={"cas.tgc.crypto.enabled=false"})
@Import(value={WSFederationValidateRequestCallbackControllerTestConfiguration.class})
public class WSFederationValidateRequestCallbackControllerTests
extends BaseCoreWsSecurityIdentityProviderConfigurationTests {
    @Autowired
    @Qualifier(value="federationValidateRequestCallbackController")
    private WSFederationValidateRequestCallbackController federationValidateRequestCallbackController;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private CasCookieBuilder ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;

    @Test
    public void verifyWithTicketGrantingTicket() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", registeredService.getRealm());
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wa", "wsignin1.0");
        request.addParameter("wctx", UUID.randomUUID().toString());
        ModelAndView mv = this.federationValidateRequestCallbackController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
        Assertions.assertEquals((Object)"error", (Object)mv.getViewName());
        SecurityToken token = new SecurityToken(UUID.randomUUID().toString());
        String id = UUID.randomUUID().toString();
        SecurityTokenTicket sts = (SecurityTokenTicket)Mockito.mock(SecurityTokenTicket.class);
        Mockito.when((Object)sts.getPrefix()).thenReturn((Object)"STS");
        Mockito.when((Object)sts.getId()).thenReturn((Object)("STS-" + id));
        Mockito.when((Object)sts.isExpired()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)sts.getSecurityToken()).thenReturn((Object)token);
        this.ticketRegistry.addTicket((Ticket)sts);
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        tgt.getDescendantTickets().add(sts.getId());
        this.ticketRegistry.addTicket((Ticket)tgt);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
        service.getAttributes().put("wreply", List.of(registeredService.getServiceId()));
        MockServiceTicket st = new MockServiceTicket("123456", (Service)service, (TicketGrantingTicket)tgt);
        this.ticketRegistry.addTicket((Ticket)st);
        request.addParameter("ticket", st.getId());
        this.ticketGrantingTicketCookieGenerator.addCookie((HttpServletResponse)response, tgt.getId());
        request.setCookies(response.getCookies());
        mv = this.federationValidateRequestCallbackController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
        Assertions.assertEquals((Object)"casPostResponseView", (Object)mv.getViewName());
    }

    @Test
    public void verifyWithoutTicketGrantingTicket() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", registeredService.getRealm());
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wa", "wsignin1.0");
        request.addParameter("wctx", UUID.randomUUID().toString());
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        this.ticketRegistry.addTicket((Ticket)tgt);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
        service.getAttributes().put("wreply", List.of(registeredService.getServiceId()));
        MockServiceTicket st = new MockServiceTicket("123456", (Service)service, (TicketGrantingTicket)tgt);
        this.ticketRegistry.addTicket((Ticket)st);
        request.addParameter("ticket", st.getId());
        this.ticketGrantingTicketCookieGenerator.addCookie((HttpServletResponse)response, tgt.getId());
        request.setCookies(response.getCookies());
        ModelAndView mv = this.federationValidateRequestCallbackController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
        Assertions.assertEquals((Object)"casPostResponseView", (Object)mv.getViewName());
    }

    private WSFederationRegisteredService getWsFederationRegisteredService() {
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm("urn:org:apereo:cas:ws:idp:realm-CAS");
        registeredService.setServiceId("http://app.example5.org/wsfed-idp");
        registeredService.setName("WSFED App");
        registeredService.setId(100L);
        registeredService.setAppliesTo("CAS");
        registeredService.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }

    @TestConfiguration
    public static class WSFederationValidateRequestCallbackControllerTestConfiguration {
        @Bean
        public WSFederationRelyingPartyTokenProducer wsFederationRelyingPartyTokenProducer() {
            WSFederationRelyingPartyTokenProducer producer = (WSFederationRelyingPartyTokenProducer)Mockito.mock(WSFederationRelyingPartyTokenProducer.class);
            Mockito.when((Object)producer.produce((SecurityToken)Mockito.any(), (WSFederationRegisteredService)Mockito.any(), (WSFederationRequest)Mockito.any(), (HttpServletRequest)Mockito.any(), (Assertion)Mockito.any())).thenReturn((Object)UUID.randomUUID().toString());
            return producer;
        }

        @Bean
        public SecurityTokenServiceTokenFetcher securityTokenServiceTokenFetcher() {
            SecurityToken token = new SecurityToken(UUID.randomUUID().toString());
            SecurityTokenServiceTokenFetcher fetcher = (SecurityTokenServiceTokenFetcher)Mockito.mock(SecurityTokenServiceTokenFetcher.class);
            Mockito.when((Object)fetcher.fetch((Service)Mockito.any(), Mockito.anyString())).thenReturn(Optional.of(token));
            return fetcher;
        }

        @Bean
        public AbstractUrlBasedTicketValidator casClientTicketValidator() {
            return new AbstractUrlBasedTicketValidator("https://cas.example.org"){

                protected String getUrlSuffix() {
                    return "/cas";
                }

                protected Assertion parseResponseFromServer(String s) {
                    return new AssertionImpl((AttributePrincipal)new AttributePrincipalImpl("casuser", CollectionUtils.wrap((String)"name", (Object)"value")));
                }

                protected String retrieveResponseFromServer(URL url, String s) {
                    return "theresponse";
                }
            };
        }
    }
}

