/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.web;

import java.time.Clock;
import java.time.Instant;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.BaseCoreWsSecurityIdentityProviderConfigurationTests;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.SecurityTokenTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.apereo.cas.ws.idp.web.WSFederationRequest;
import org.apereo.cas.ws.idp.web.WSFederationValidateRequestController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"cas.tgc.crypto.enabled=false"})
@Tag(value="WSFederation")
public class WSFederationValidateRequestControllerTests
extends BaseCoreWsSecurityIdentityProviderConfigurationTests {
    @Autowired
    @Qualifier(value="federationValidateRequestController")
    private WSFederationValidateRequestController federationValidateRequestController;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private CasCookieBuilder ticketGrantingTicketCookieGenerator;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;

    @Test
    public void verifyNoWa() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assertions.assertThrows(UnauthorizedAuthenticationException.class, () -> this.federationValidateRequestController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request));
    }

    @Test
    public void verifyLogoutWithReply() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", registeredService.getRealm());
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wa", "wsignout1.0");
        request.addParameter("whr", "whr");
        request.addParameter("wreq", "wreq");
        Assertions.assertDoesNotThrow(() -> {
            this.federationValidateRequestController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
            return null;
        });
        Assertions.assertEquals((int)302, (int)response.getStatus());
        Assertions.assertEquals((Object)"https://cas.example.org:8443/cas/logout?service=http://app.example5.org/wsfed-idp", (Object)response.getHeader("Location"));
    }

    @Test
    public void verifyUnauthzServicesWithUnknownRealm() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", "unknown");
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wa", "wsignout1.0");
        WSFederationRequest wsFedRequest = WSFederationRequest.of((HttpServletRequest)request);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> this.federationValidateRequestController.findAndValidateFederationRequestForRegisteredService((Service)service, wsFedRequest));
    }

    @Test
    public void verifyUnauthzServicesWithMismatchedRealm() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService("custom-realm");
        request.addParameter("wtrealm", "custom-realm");
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wa", "wsignout1.0");
        WSFederationRequest wsFedRequest = WSFederationRequest.of((HttpServletRequest)request);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)registeredService.getServiceId());
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> this.federationValidateRequestController.findAndValidateFederationRequestForRegisteredService((Service)service, wsFedRequest));
    }

    @Test
    public void verifyLogoutWithoutReply() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addParameter("wa", "wsignout1.0");
        Assertions.assertDoesNotThrow(() -> {
            this.federationValidateRequestController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
            return null;
        });
        Assertions.assertEquals((int)302, (int)response.getStatus());
        Assertions.assertEquals((Object)"https://cas.example.org:8443/cas/logout", (Object)response.getHeader("Location"));
    }

    @Test
    public void verifyLogin() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", registeredService.getRealm());
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wa", "wsignin1.0");
        Assertions.assertDoesNotThrow(() -> {
            this.federationValidateRequestController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
            return null;
        });
        Assertions.assertEquals((int)302, (int)response.getStatus());
        URIBuilder builder = new URIBuilder(response.getHeader("Location"));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("service")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wtrealm")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wreply")));
    }

    @Test
    public void verifyLoginRenewWithNoToken() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", registeredService.getRealm());
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wfresh", "5000");
        request.addParameter("wa", "wsignin1.0");
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        this.ticketRegistry.addTicket((Ticket)tgt);
        Assertions.assertDoesNotThrow(() -> {
            this.federationValidateRequestController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
            return null;
        });
        Assertions.assertEquals((int)302, (int)response.getStatus());
        URIBuilder builder = new URIBuilder(response.getHeader("Location"));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("service")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("renew")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wtrealm")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wreply")));
    }

    @Test
    public void verifyLoginRenewDisabled() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", registeredService.getRealm());
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wfresh", "0");
        request.addParameter("wa", "wsignin1.0");
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        this.ticketRegistry.addTicket((Ticket)tgt);
        Assertions.assertDoesNotThrow(() -> {
            this.federationValidateRequestController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
            return null;
        });
        Assertions.assertNotNull((Object)this.federationValidateRequestController.handleUnauthorizedServiceException((HttpServletRequest)request, (Exception)new RuntimeException()));
        Assertions.assertEquals((int)302, (int)response.getStatus());
        URIBuilder builder = new URIBuilder(response.getHeader("Location"));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("service")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wtrealm")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wreply")));
    }

    @Test
    public void verifyLoginRenewWithToken() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        WSFederationRegisteredService registeredService = this.getWsFederationRegisteredService();
        request.addParameter("wtrealm", registeredService.getRealm());
        request.addParameter("wreply", registeredService.getServiceId());
        request.addParameter("wfresh", "1");
        request.addParameter("wa", "wsignin1.0");
        SecurityToken token = (SecurityToken)Mockito.mock(SecurityToken.class);
        Mockito.when((Object)token.isExpired()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)token.getCreated()).thenReturn((Object)Instant.now(Clock.systemUTC()).minusSeconds(300L));
        String id = UUID.randomUUID().toString();
        SecurityTokenTicket sts = (SecurityTokenTicket)Mockito.mock(SecurityTokenTicket.class);
        Mockito.when((Object)sts.getPrefix()).thenReturn((Object)"STS");
        Mockito.when((Object)sts.getId()).thenReturn((Object)("STS-" + id));
        Mockito.when((Object)sts.isExpired()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)sts.getSecurityToken()).thenReturn((Object)token);
        this.ticketRegistry.addTicket((Ticket)sts);
        MockTicketGrantingTicket tgt = new MockTicketGrantingTicket("casuser");
        tgt.getDescendantTickets().add(sts.getId());
        this.ticketRegistry.addTicket((Ticket)tgt);
        this.ticketGrantingTicketCookieGenerator.addCookie((HttpServletResponse)response, tgt.getId());
        request.setCookies(response.getCookies());
        Assertions.assertDoesNotThrow(() -> {
            this.federationValidateRequestController.handleFederationRequest((HttpServletResponse)response, (HttpServletRequest)request);
            return null;
        });
        Assertions.assertEquals((int)302, (int)response.getStatus());
        URIBuilder builder = new URIBuilder(response.getHeader("Location"));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("service")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("renew")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wtrealm")));
        Assertions.assertTrue((boolean)builder.getQueryParams().stream().anyMatch(p -> p.getName().equals("wreply")));
    }

    private WSFederationRegisteredService getWsFederationRegisteredService() {
        return this.getWsFederationRegisteredService("urn:org:apereo:cas:ws:idp:realm-CAS");
    }

    private WSFederationRegisteredService getWsFederationRegisteredService(String realm) {
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm(realm);
        registeredService.setServiceId("http://app.example5.org/wsfed-idp");
        registeredService.setName("WSFED App");
        registeredService.setId(100L);
        registeredService.setAppliesTo("CAS");
        registeredService.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        this.servicesManager.save((RegisteredService)registeredService);
        return registeredService;
    }
}

