/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ws.idp.web.flow;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.BaseCoreWsSecurityIdentityProviderConfigurationTests;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.MockServletContext;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowActions")
public class WSFederationMetadataUIActionTests
extends BaseCoreWsSecurityIdentityProviderConfigurationTests {
    @Autowired
    @Qualifier(value="wsFederationMetadataUIAction")
    private Action wsFederationMetadataUIAction;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @Test
    public void verifyOperation() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        WSFederationRegisteredService registeredService = new WSFederationRegisteredService();
        registeredService.setRealm("CAS");
        registeredService.setServiceId("http://app.example5.org/wsfed-idp");
        registeredService.setName("WSFED App");
        registeredService.setId(100L);
        registeredService.setAppliesTo("CAS");
        registeredService.setWsdlLocation("classpath:wsdl/ws-trust-1.4-service.wsdl");
        this.servicesManager.save((RegisteredService)registeredService);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)"http://app.example5.org/wsfed-idp");
        service.getAttributes().put("wreply", List.of(registeredService.getServiceId()));
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        Event event = this.wsFederationMetadataUIAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"success", (Object)event.getId());
    }
}

