/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.HashMap;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.authentication.SecurityTokenServiceClient;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationProperties;
import org.apereo.cas.ws.idp.services.WSFederationRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTokenServiceClientBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityTokenServiceClientBuilder.class);
    private final WsFederationProperties wsFederationProperties;
    private final String prefix;

    public SecurityTokenServiceClient buildClientForSecurityTokenRequests(WSFederationRegisteredService service) {
        Bus cxfBus = BusFactory.getDefaultBus();
        SecurityTokenServiceClient sts = new SecurityTokenServiceClient(cxfBus);
        sts.setAddressingNamespace((String)StringUtils.defaultIfBlank((CharSequence)service.getAddressingNamespace(), (CharSequence)"http://www.w3.org/2005/08/addressing"));
        sts.setTokenType((String)StringUtils.defaultIfBlank((CharSequence)service.getTokenType(), (CharSequence)"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.setWsdlLocation(this.prepareWsdlLocation(service));
        if (StringUtils.isNotBlank((CharSequence)service.getPolicyNamespace())) {
            sts.setWspNamespace(service.getPolicyNamespace());
        }
        String namespace = (String)StringUtils.defaultIfBlank((CharSequence)service.getNamespace(), (CharSequence)"http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
        sts.setServiceQName(new QName(namespace, (String)StringUtils.defaultIfBlank((CharSequence)service.getWsdlService(), (CharSequence)"SecurityTokenService")));
        sts.setEndpointQName(new QName(namespace, service.getWsdlEndpoint()));
        sts.getProperties().putAll(new HashMap());
        return sts;
    }

    private String prepareWsdlLocation(WSFederationRegisteredService service) {
        if (StringUtils.isNotBlank((CharSequence)service.getWsdlLocation())) {
            return service.getWsdlLocation();
        }
        String wsdl = String.format("/ws/sts/%s/STSServiceTransportUT?wsdl", this.wsFederationProperties.getIdp().getRealmName());
        return this.prefix.concat(wsdl);
    }

    public SecurityTokenServiceClient buildClientForRelyingPartyTokenResponses(SecurityToken securityToken, WSFederationRegisteredService service) {
        Bus cxfBus = BusFactory.getDefaultBus();
        SecurityTokenServiceClient sts = new SecurityTokenServiceClient(cxfBus);
        sts.setAddressingNamespace((String)StringUtils.defaultIfBlank((CharSequence)service.getAddressingNamespace(), (CharSequence)"http://www.w3.org/2005/08/addressing"));
        sts.setWsdlLocation(this.prepareWsdlLocation(service));
        String namespace = (String)StringUtils.defaultIfBlank((CharSequence)service.getNamespace(), (CharSequence)"http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
        sts.setServiceQName(new QName(namespace, service.getWsdlService()));
        sts.setEndpointQName(new QName(namespace, service.getWsdlEndpoint()));
        sts.setEnableAppliesTo(StringUtils.isNotBlank((CharSequence)service.getAppliesTo()));
        sts.setOnBehalfOf(securityToken.getToken());
        sts.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        sts.setTokenType((String)StringUtils.defaultIfBlank((CharSequence)service.getTokenType(), (CharSequence)"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0"));
        if (StringUtils.isNotBlank((CharSequence)service.getPolicyNamespace())) {
            sts.setWspNamespace(service.getPolicyNamespace());
        }
        return sts;
    }

    @Generated
    public SecurityTokenServiceClientBuilder(WsFederationProperties wsFederationProperties, String prefix) {
        this.wsFederationProperties = wsFederationProperties;
        this.prefix = prefix;
    }
}

