/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.DefaultSecurityTokenTicket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casWsSecurityTokenTicketCatalogConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWsSecurityTokenTicketCatalogConfiguration
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWsSecurityTokenTicketCatalogConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    public void configureTicketCatalog(TicketCatalog plan) {
        LOGGER.debug("Registering core WS security token ticket definitions...");
        TicketDefinition defn = this.buildTicketDefinition(plan, "STS", DefaultSecurityTokenTicket.class);
        defn.getProperties().setStorageName("wsSecurityTokenTicketsCache");
        defn.getProperties().setStorageTimeout((long)this.casProperties.getTicket().getTgt().getMaxTimeToLiveInSeconds());
        this.registerTicketDefinition(plan, defn);
    }
}

