/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.Servlet;
import javax.xml.ws.Provider;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.StaticSTSProperties;
import org.apache.cxf.sts.claims.ClaimsAttributeStatementProvider;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsManager;
import org.apache.cxf.sts.event.STSEventListener;
import org.apache.cxf.sts.event.map.EventMapper;
import org.apache.cxf.sts.event.map.MapEventListener;
import org.apache.cxf.sts.event.map.MapEventLogger;
import org.apache.cxf.sts.operation.TokenIssueOperation;
import org.apache.cxf.sts.operation.TokenValidateOperation;
import org.apache.cxf.sts.service.StaticService;
import org.apache.cxf.sts.token.delegation.SAMLDelegationHandler;
import org.apache.cxf.sts.token.delegation.TokenDelegationHandler;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultSubjectProvider;
import org.apache.cxf.sts.token.provider.SAMLTokenProvider;
import org.apache.cxf.sts.token.provider.SubjectProvider;
import org.apache.cxf.sts.token.realm.RealmProperties;
import org.apache.cxf.sts.token.realm.Relationship;
import org.apache.cxf.sts.token.validator.SAMLTokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.X509TokenValidator;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.ws.security.sts.provider.SecurityTokenServiceProvider;
import org.apache.cxf.ws.security.sts.provider.operation.IssueOperation;
import org.apache.cxf.ws.security.sts.provider.operation.ValidateOperation;
import org.apache.wss4j.dom.validate.Validator;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.SecurityTokenServiceClientBuilder;
import org.apereo.cas.authentication.SecurityTokenServiceTokenFetcher;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.claims.CustomWSFederationClaimsClaimsHandler;
import org.apereo.cas.support.claims.NonWSFederationClaimsClaimsHandler;
import org.apereo.cas.support.claims.WrappingSecurityTokenServiceClaimsHandler;
import org.apereo.cas.support.realm.RealmPasswordVerificationCallbackHandler;
import org.apereo.cas.support.realm.UriRealmParser;
import org.apereo.cas.support.util.CryptoUtils;
import org.apereo.cas.support.validation.CipheredCredentialsValidator;
import org.apereo.cas.support.validation.SecurityTokenServiceCredentialCipherExecutor;
import org.apereo.cas.support.x509.X509TokenDelegationHandler;
import org.apereo.cas.ticket.DefaultSecurityTokenTicketFactory;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.SecurityTokenTicketFactory;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration(value="coreWsSecuritySecurityTokenServiceConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ImportResource(locations={"classpath:jaxws-realms.xml", "classpath:META-INF/cxf/cxf.xml"})
public class CoreWsSecuritySecurityTokenServiceConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreWsSecuritySecurityTokenServiceConfiguration.class);
    @Autowired
    @Qualifier(value="grantingTicketExpirationPolicy")
    private ExpirationPolicy grantingTicketExpirationPolicy;
    @Autowired
    @Qualifier(value="wsFederationAuthenticationServiceSelectionStrategy")
    private AuthenticationServiceSelectionStrategy wsFederationAuthenticationServiceSelectionStrategy;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public ServletRegistrationBean cxfServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setEnabled(true);
        bean.setName("cxfServletSecurityTokenService");
        bean.setServlet((Servlet)new CXFServlet());
        bean.setUrlMappings((Collection)CollectionUtils.wrap((Object)"/ws/sts/".concat("*")));
        bean.setAsyncSupported(true);
        return bean;
    }

    @Bean
    public EventMapper loggerListener() {
        return new EventMapper((MapEventListener)new MapEventLogger());
    }

    @Bean
    @RefreshScope
    public List<TokenDelegationHandler> delegationHandlers() {
        ArrayList<TokenDelegationHandler> handlers = new ArrayList<TokenDelegationHandler>();
        handlers.add((TokenDelegationHandler)new SAMLDelegationHandler());
        handlers.add(new X509TokenDelegationHandler());
        return handlers;
    }

    @Bean
    public Provider transportSTSProviderBean() {
        SecurityTokenServiceProvider provider = new SecurityTokenServiceProvider();
        provider.setIssueOperation(this.transportIssueDelegate());
        provider.setValidateOperation(this.transportValidateDelegate());
        return provider;
    }

    @Bean
    public IssueOperation transportIssueDelegate() {
        WsFederationProperties.SecurityTokenService wsfed = this.casProperties.getAuthn().getWsfedIdp().getSts();
        WsFederationProperties.IdentityProvider idp = this.casProperties.getAuthn().getWsfedIdp().getIdp();
        ClaimsManager claimsManager = new ClaimsManager();
        WrappingSecurityTokenServiceClaimsHandler stsHandler = new WrappingSecurityTokenServiceClaimsHandler(idp.getRealmName(), wsfed.getRealm().getIssuer());
        NonWSFederationClaimsClaimsHandler casHandler = new NonWSFederationClaimsClaimsHandler(idp.getRealmName(), wsfed.getRealm().getIssuer());
        CustomWSFederationClaimsClaimsHandler customHandler = new CustomWSFederationClaimsClaimsHandler(idp.getRealmName(), wsfed.getRealm().getIssuer(), wsfed.getCustomClaims());
        claimsManager.setClaimHandlers(CollectionUtils.wrapList((Object[])new ClaimsHandler[]{stsHandler, casHandler, customHandler}));
        TokenIssueOperation op = new TokenIssueOperation();
        op.setTokenProviders(this.transportTokenProviders());
        op.setServices(CollectionUtils.wrap((Object)this.transportService()));
        op.setStsProperties(this.transportSTSProperties());
        op.setClaimsManager(claimsManager);
        op.setTokenValidators(this.transportTokenValidators());
        op.setEventListener((STSEventListener)this.loggerListener());
        op.setDelegationHandlers(this.delegationHandlers());
        op.setEncryptIssuedToken(wsfed.isEncryptTokens());
        return op;
    }

    @Bean
    public ValidateOperation transportValidateDelegate() {
        TokenValidateOperation op = new TokenValidateOperation();
        op.setTokenValidators(this.transportTokenValidators());
        op.setStsProperties(this.transportSTSProperties());
        op.setEventListener((STSEventListener)this.loggerListener());
        return op;
    }

    @Bean
    @RefreshScope
    public List transportTokenValidators() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.transportSamlTokenValidator());
        list.add(new X509TokenValidator());
        return list;
    }

    @Bean
    @RefreshScope
    public List transportTokenProviders() {
        ArrayList<SAMLTokenProvider> list = new ArrayList<SAMLTokenProvider>();
        list.add(this.transportSamlTokenProvider());
        return list;
    }

    @Bean
    public RealmProperties casRealm() {
        WsFederationProperties.SecurityTokenService wsfed = this.casProperties.getAuthn().getWsfedIdp().getSts();
        RealmProperties realm = new RealmProperties();
        realm.setIssuer(wsfed.getRealm().getIssuer());
        if (StringUtils.isBlank((CharSequence)wsfed.getRealm().getKeystoreFile()) || StringUtils.isBlank((CharSequence)wsfed.getRealm().getKeyPassword()) || StringUtils.isBlank((CharSequence)wsfed.getRealm().getKeystoreAlias())) {
            throw new BeanCreationException("Keystore file, password or alias assigned to the realm must be defined");
        }
        Properties p = CryptoUtils.getSecurityProperties(wsfed.getRealm().getKeystoreFile(), wsfed.getRealm().getKeystorePassword(), wsfed.getRealm().getKeystoreAlias());
        realm.setSignatureCryptoProperties((Object)p);
        realm.setCallbackHandler((CallbackHandler)new RealmPasswordVerificationCallbackHandler(wsfed.getRealm().getKeyPassword()));
        return realm;
    }

    @Bean
    @RefreshScope
    public Map<String, RealmProperties> realms() {
        WsFederationProperties.IdentityProvider idp = this.casProperties.getAuthn().getWsfedIdp().getIdp();
        HashMap<String, RealmProperties> realms = new HashMap<String, RealmProperties>();
        realms.put(idp.getRealmName(), this.casRealm());
        return realms;
    }

    @ConditionalOnMissingBean(name={"transportSamlTokenProvider"})
    @Bean
    public SAMLTokenProvider transportSamlTokenProvider() {
        WsFederationProperties.SecurityTokenService wsfed = this.casProperties.getAuthn().getWsfedIdp().getSts();
        DefaultSubjectProvider s = new DefaultSubjectProvider();
        switch (wsfed.getSubjectNameIdFormat().trim().toLowerCase()) {
            case "email": {
                s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
                break;
            }
            case "entity": {
                s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
                break;
            }
            case "transient": {
                s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
                break;
            }
            default: {
                s.setSubjectNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            }
        }
        DefaultConditionsProvider c = new DefaultConditionsProvider();
        if (StringUtils.isNotBlank((CharSequence)wsfed.getSubjectNameQualifier())) {
            s.setSubjectNameQualifier(wsfed.getSubjectNameQualifier());
        }
        c.setAcceptClientLifetime(wsfed.isConditionsAcceptClientLifetime());
        c.setFailLifetimeExceedance(wsfed.isConditionsFailLifetimeExceedance());
        c.setFutureTimeToLive(Beans.newDuration((String)wsfed.getConditionsFutureTimeToLive()).getSeconds());
        c.setLifetime(Beans.newDuration((String)wsfed.getConditionsLifetime()).getSeconds());
        c.setMaxLifetime(Beans.newDuration((String)wsfed.getConditionsMaxLifetime()).getSeconds());
        SAMLTokenProvider provider = new SAMLTokenProvider();
        provider.setAttributeStatementProviders(CollectionUtils.wrap((Object)new ClaimsAttributeStatementProvider()));
        provider.setRealmMap(this.realms());
        provider.setConditionsProvider((ConditionsProvider)c);
        provider.setSubjectProvider((SubjectProvider)s);
        return provider;
    }

    @ConditionalOnMissingBean(name={"transportSamlTokenValidator"})
    @Bean
    public TokenValidator transportSamlTokenValidator() {
        return new SAMLTokenValidator();
    }

    @ConditionalOnMissingBean(name={"transportUsernameTokenValidator"})
    @Bean
    public Validator transportUsernameTokenValidator() {
        return new CipheredCredentialsValidator(this.securityTokenServiceCredentialCipherExecutor());
    }

    @ConditionalOnMissingBean(name={"transportService"})
    @Bean
    public StaticService transportService() {
        StaticService s = new StaticService();
        s.setEndpoints(CollectionUtils.wrap((Object)".*"));
        return s;
    }

    @ConditionalOnMissingBean(name={"transportSTSProperties"})
    @Bean
    public STSPropertiesMBean transportSTSProperties() {
        WsFederationProperties.SecurityTokenService wsfed = this.casProperties.getAuthn().getWsfedIdp().getSts();
        WsFederationProperties.IdentityProvider idp = this.casProperties.getAuthn().getWsfedIdp().getIdp();
        StaticSTSProperties s = new StaticSTSProperties();
        s.setIssuer(this.getClass().getSimpleName());
        s.setRealmParser((RealmParser)new UriRealmParser(this.realms()));
        s.setSignatureCryptoProperties((Object)CryptoUtils.getSecurityProperties(wsfed.getSigningKeystoreFile(), wsfed.getSigningKeystorePassword()));
        s.setEncryptionCryptoProperties((Object)CryptoUtils.getSecurityProperties(wsfed.getEncryptionKeystoreFile(), wsfed.getEncryptionKeystorePassword()));
        Relationship rel = new Relationship();
        rel.setType("FederatedIdentity");
        rel.setSourceRealm(idp.getRealmName());
        rel.setTargetRealm(idp.getRealmName());
        s.setRelationships(CollectionUtils.wrap((Object)rel));
        return s;
    }

    @Bean
    public SecurityTokenServiceClientBuilder securityTokenServiceClientBuilder() {
        return new SecurityTokenServiceClientBuilder(this.casProperties.getAuthn().getWsfedIdp(), this.casProperties.getServer().getPrefix());
    }

    @ConditionalOnMissingBean(name={"securityTokenServiceTokenFetcher"})
    @Bean
    public SecurityTokenServiceTokenFetcher securityTokenServiceTokenFetcher() {
        return new SecurityTokenServiceTokenFetcher(this.servicesManager, this.wsFederationAuthenticationServiceSelectionStrategy, (CipherExecutor<String, String>)this.securityTokenServiceCredentialCipherExecutor(), this.securityTokenServiceClientBuilder());
    }

    @Bean
    @RefreshScope
    public CipherExecutor securityTokenServiceCredentialCipherExecutor() {
        WsFederationProperties.SecurityTokenService wsfed = this.casProperties.getAuthn().getWsfedIdp().getSts();
        return new SecurityTokenServiceCredentialCipherExecutor(wsfed.getCrypto().getEncryption().getKey(), wsfed.getCrypto().getSigning().getKey(), wsfed.getCrypto().getAlg());
    }

    @Bean
    @RefreshScope
    public SecurityTokenTicketFactory securityTokenTicketFactory() {
        return new DefaultSecurityTokenTicketFactory(this.securityTokenTicketIdGenerator(), this.grantingTicketExpirationPolicy);
    }

    @ConditionalOnMissingBean(name={"securityTokenTicketIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator securityTokenTicketIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }
}

