/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.lang.reflect.Field;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apereo.cas.config.CoreSamlConfiguration;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

@Configuration(value="coreWsSecuritySecurityTokenServiceSamlConfiguration")
@AutoConfigureAfter(value={CoreSamlConfiguration.class})
public class CoreWsSecuritySecurityTokenServiceSamlConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreWsSecuritySecurityTokenServiceSamlConfiguration.class);
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean openSamlConfigBean;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        String warningMessage = "The security token service configuration of CAS will try to disable the OpenSAML bootstrapping process by wss4j, as it interferes with and prevents CAS' own initialization of OpenSAML. Given the current API limitations of the wss4j library, which is responsible for the implementation of the security token service in CAS, Java reflection is used to disable the OpenSAML bootstrapping process. This approach is prone to error, and may be revisited in future versions of CAS, once the wss4j library opens up its OpenSAML bootstrapping API in more extensible ways";
        LOGGER.warn("The security token service configuration of CAS will try to disable the OpenSAML bootstrapping process by wss4j, as it interferes with and prevents CAS' own initialization of OpenSAML. Given the current API limitations of the wss4j library, which is responsible for the implementation of the security token service in CAS, Java reflection is used to disable the OpenSAML bootstrapping process. This approach is prone to error, and may be revisited in future versions of CAS, once the wss4j library opens up its OpenSAML bootstrapping API in more extensible ways");
        WSProviderConfig.init();
        Field providerRegistry = ReflectionUtils.findField(OpenSAMLUtil.class, (String)"providerRegistry");
        Field builderFactory = ReflectionUtils.findField(OpenSAMLUtil.class, (String)"builderFactory");
        Field marshallerFactory = ReflectionUtils.findField(OpenSAMLUtil.class, (String)"marshallerFactory");
        Field unmarshallerFactory = ReflectionUtils.findField(OpenSAMLUtil.class, (String)"unmarshallerFactory");
        Field samlEngineInitialized = ReflectionUtils.findField(OpenSAMLUtil.class, (String)"samlEngineInitialized");
        ReflectionUtils.makeAccessible((Field)providerRegistry);
        ReflectionUtils.makeAccessible((Field)builderFactory);
        ReflectionUtils.makeAccessible((Field)marshallerFactory);
        ReflectionUtils.makeAccessible((Field)unmarshallerFactory);
        ReflectionUtils.makeAccessible((Field)samlEngineInitialized);
        providerRegistry.set(null, ConfigurationService.get(XMLObjectProviderRegistry.class));
        builderFactory.set(null, this.openSamlConfigBean.getBuilderFactory());
        marshallerFactory.set(null, this.openSamlConfigBean.getMarshallerFactory());
        unmarshallerFactory.set(null, this.openSamlConfigBean.getUnmarshallerFactory());
        samlEngineInitialized.setBoolean(null, true);
    }
}

