/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.claims;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.support.claims.NonWSFederationClaimsClaimsHandler;

public class CustomWSFederationClaimsClaimsHandler
extends NonWSFederationClaimsClaimsHandler {
    private final List<URI> supportedClaimTypes;

    public CustomWSFederationClaimsClaimsHandler(String handlerRealm, String issuer, List<String> namespaces) {
        super(handlerRealm, issuer);
        this.supportedClaimTypes = new NonWSFederationClaimsList(namespaces);
    }

    @Override
    public List<URI> getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    private static class NonWSFederationClaimsList
    extends ArrayList<URI> {
        private static final long serialVersionUID = 8368878016992806802L;
        private final List<String> namespaces;

        @Override
        public boolean contains(Object o) {
            String uri = ((URI)o).toASCIIString();
            return this.namespaces.stream().anyMatch(uri::startsWith);
        }

        @Generated
        public NonWSFederationClaimsList(List<String> namespaces) {
            this.namespaces = namespaces;
        }
    }
}

