/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.claims;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apereo.cas.support.claims.WrappingSecurityTokenServiceClaimsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonWSFederationClaimsClaimsHandler
extends WrappingSecurityTokenServiceClaimsHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(NonWSFederationClaimsClaimsHandler.class);

    public NonWSFederationClaimsClaimsHandler(String handlerRealm, String issuer) {
        super(handlerRealm, issuer);
    }

    @Override
    protected URI createProcessedClaimType(Claim requestClaim, ClaimsParameters parameters) {
        String tokenType = parameters.getTokenRequirements().getTokenType();
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equalsIgnoreCase(tokenType)) {
            String value = StringUtils.remove((String)requestClaim.getClaimType().toASCIIString(), (String)"http://www.yale.edu/tp/cas/");
            return new URI(value);
        }
        return requestClaim.getClaimType();
    }

    @Override
    public List<URI> getSupportedClaimTypes() {
        return new NonWSFederationClaimsList();
    }

    private static class NonWSFederationClaimsList
    extends ArrayList<URI> {
        private NonWSFederationClaimsList() {
        }

        @Override
        public boolean contains(Object o) {
            return o.toString().startsWith("http://www.yale.edu/tp/cas/");
        }
    }
}

