/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.claims;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import lombok.Generated;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.token.realm.RealmSupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.ws.idp.WSFederationClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappingSecurityTokenServiceClaimsHandler
implements ClaimsHandler,
RealmSupport {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WrappingSecurityTokenServiceClaimsHandler.class);
    private final String handlerRealm;
    private final String issuer;

    public List<URI> getSupportedClaimTypes() {
        return WSFederationClaims.ALL_CLAIMS.stream().map(c -> UriBuilder.fromUri((String)c.getUri()).build(new Object[0])).collect(Collectors.toList());
    }

    public ProcessedClaimCollection retrieveClaimValues(ClaimCollection claims, ClaimsParameters parameters) {
        if (parameters.getRealm() == null || !parameters.getRealm().equalsIgnoreCase(this.handlerRealm)) {
            LOGGER.warn("Realm [{}] doesn't match with configured realm [{}]", (Object)parameters.getRealm(), (Object)this.handlerRealm);
            return new ProcessedClaimCollection();
        }
        if (parameters.getPrincipal() == null) {
            LOGGER.warn("No principal could be identified in the claim parameters request");
            return new ProcessedClaimCollection();
        }
        if (claims == null || claims.isEmpty()) {
            LOGGER.warn("No claims are available to process");
            return new ProcessedClaimCollection();
        }
        ProcessedClaimCollection claimCollection = new ProcessedClaimCollection();
        claims.stream().map(c -> this.createProcessedClaim((Claim)c, parameters)).forEach(arg_0 -> claimCollection.add(arg_0));
        return claimCollection;
    }

    protected ProcessedClaim createProcessedClaim(Claim requestClaim, ClaimsParameters parameters) {
        ProcessedClaim claim = new ProcessedClaim();
        claim.setClaimType(this.createProcessedClaimType(requestClaim, parameters));
        claim.setIssuer(this.issuer);
        claim.setOriginalIssuer(this.issuer);
        claim.setValues(requestClaim.getValues());
        return claim;
    }

    protected URI createProcessedClaimType(Claim requestClaim, ClaimsParameters parameters) {
        return requestClaim.getClaimType();
    }

    public List<String> getSupportedRealms() {
        return CollectionUtils.wrap((Object)this.handlerRealm);
    }

    @Generated
    public String getHandlerRealm() {
        return this.handlerRealm;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public WrappingSecurityTokenServiceClaimsHandler(String handlerRealm, String issuer) {
        this.handlerRealm = handlerRealm;
        this.issuer = issuer;
    }
}

