/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.claims;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsFederationClaimsEncoder
implements ProtocolAttributeEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationClaimsEncoder.class);

    public Map<String, Object> encodeAttributes(Map<String, Object> attributes, RegisteredService service) {
        HashMap finalAttributes = Maps.newHashMapWithExpectedSize((int)attributes.size());
        attributes.forEach((k, v) -> {
            String attributeName = EncodingUtils.hexDecode((String)k);
            if (StringUtils.isNotBlank((CharSequence)attributeName)) {
                LOGGER.debug("Decoded SAML attribute [{}] to [{}] with value(s) [{}]", new Object[]{k, attributeName, v});
                finalAttributes.put(attributeName, v);
            } else {
                LOGGER.debug("Unable to decode SAML attribute [{}]; accepting it verbatim", k);
                finalAttributes.put(k, v);
            }
        });
        return finalAttributes;
    }

    public String encodeClaim(String claim) {
        String attributeName = EncodingUtils.hexDecode((String)claim);
        if (StringUtils.isNotBlank((CharSequence)attributeName)) {
            LOGGER.debug("Decoded SAML attribute [{}] to [{}] with value(s) [{}]", new Object[]{claim, attributeName, claim});
            return attributeName;
        }
        LOGGER.debug("Unable to decode SAML attribute [{}]; accepting it verbatim", (Object)claim);
        return claim;
    }
}

