/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.realm;

import java.util.Map;
import java.util.StringTokenizer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.token.realm.RealmProperties;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriRealmParser
implements RealmParser {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UriRealmParser.class);
    private final Map<String, RealmProperties> realmMap;

    public String parseRealm(Map<String, Object> messageContext) throws STSException {
        String url = (String)messageContext.get("org.apache.cxf.request.url");
        StringTokenizer st = new StringTokenizer(url, "/");
        String realm = null;
        int count = st.countTokens();
        if (count <= 1) {
            return null;
        }
        --count;
        for (int i = 0; i < count; ++i) {
            realm = st.nextToken();
        }
        if (StringUtils.isBlank((CharSequence)(realm = realm.toUpperCase())) || !this.realmMap.containsKey(realm)) {
            LOGGER.warn("Unknown realm: [{}]", (Object)realm);
            throw new STSException("Unknown realm: " + realm);
        }
        LOGGER.debug("URI realm parsed: [{}]", (Object)realm);
        return realm.trim();
    }

    @Generated
    public UriRealmParser(Map<String, RealmProperties> realmMap) {
        this.realmMap = realmMap;
    }
}

