/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import java.security.cert.X509Certificate;
import lombok.Generated;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlAssertionRealmCodec
implements SAMLRealmCodec {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlAssertionRealmCodec.class);
    private final String realm;
    private final boolean uppercase = true;

    public SamlAssertionRealmCodec(String realm) {
        this.realm = realm;
    }

    public String getRealmFromToken(SamlAssertionWrapper assertion) {
        SAMLKeyInfo ki = assertion.getSignatureKeyInfo();
        X509Certificate[] certs = ki.getCerts();
        String parsed = this.parseCNValue(certs[0].getSubjectX500Principal().getName());
        LOGGER.debug("Realm parsed from certificate CN of the SAML assertion: [{}]", (Object)parsed);
        if (parsed.equals(this.realm)) {
            return parsed;
        }
        LOGGER.warn("Retrieved realm from CN of SAML assertion certificate [{}] does not match the CAS realm [{}]. Beware that realm mismatch does requires configuration to implement realm relationships or identity mapping", (Object)parsed, (Object)this.realm);
        return parsed;
    }

    private String parseCNValue(String name) {
        int len = name.indexOf(44) > 0 ? name.indexOf(44) : name.length();
        String realm = name.substring(name.indexOf("CN=") + "CN=".length(), len);
        realm = realm.toUpperCase();
        return realm;
    }
}

