/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.SecurityTokenTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="SECURITYTOKENTICKET")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="STS")
public class DefaultSecurityTokenTicket
extends AbstractTicket
implements SecurityTokenTicket {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSecurityTokenTicket.class);
    private static final long serialVersionUID = 3940671352560102114L;
    @ManyToOne(targetEntity=TicketGrantingTicketImpl.class)
    private TicketGrantingTicket ticketGrantingTicket;
    @Column(name="SECURITY_TOKEN")
    private String securityToken;

    public DefaultSecurityTokenTicket(String id, TicketGrantingTicket ticketGrantingTicket, ExpirationPolicy expirationPolicy, String securityToken) {
        super(id, expirationPolicy);
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.securityToken = securityToken;
    }

    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public Authentication getAuthentication() {
        return this.getTicketGrantingTicket().getAuthentication();
    }

    public String getPrefix() {
        return "STS";
    }

    @Override
    public SecurityToken getSecurityToken() {
        byte[] securityTokenBin = EncodingUtils.decodeBase64((String)this.securityToken);
        return (SecurityToken)SerializationUtils.deserialize((byte[])securityTokenBin);
    }

    @Generated
    public DefaultSecurityTokenTicket() {
    }
}

