/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import java.nio.charset.StandardCharsets;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.config.CasWsSecurityTokenTicketCatalogConfiguration;
import org.apereo.cas.config.CasWsSecurityTokenTicketComponentSerializationConfiguration;
import org.apereo.cas.config.CoreWsSecuritySecurityTokenTicketConfiguration;
import org.apereo.cas.ticket.SecurityTokenTicket;
import org.apereo.cas.ticket.SecurityTokenTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.factory.BaseTicketFactoryTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.annotation.Import;

@Tag(value="Tickets")
@Import(value={CasWsSecurityTokenTicketCatalogConfiguration.class, CoreWsSecuritySecurityTokenTicketConfiguration.class, CasWsSecurityTokenTicketComponentSerializationConfiguration.class})
public class DefaultSecurityTokenTicketFactoryTests
extends BaseTicketFactoryTests {
    @Test
    public void verifyTicket() {
        SecurityTokenTicketFactory securityTokenTicketFactory = (SecurityTokenTicketFactory)this.ticketFactory.get(SecurityTokenTicket.class);
        Authentication originalAuthn = CoreAuthenticationTestUtils.getAuthentication();
        TicketGrantingTicketImpl tgt = new TicketGrantingTicketImpl("TGT-1234567890", originalAuthn, NeverExpiresExpirationPolicy.INSTANCE);
        SecurityTokenTicket token = securityTokenTicketFactory.create((TicketGrantingTicket)tgt, "dummy-token".getBytes(StandardCharsets.UTF_8));
        Assertions.assertNotNull((Object)token);
        String serialized = this.ticketSerializationManager.serializeTicket((Ticket)token);
        Assertions.assertNotNull((Object)serialized);
        SecurityTokenTicket result = (SecurityTokenTicket)this.ticketSerializationManager.deserializeTicket(serialized, SecurityTokenTicket.class);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)result, (Object)token);
    }
}

