/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredential;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.soap.wsfed.RequestSecurityTokenResponse;
import org.opensaml.soap.wsfed.RequestedSecurityToken;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsFederationHelper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationHelper.class);
    private final OpenSamlConfigBean configBean;
    private final ServicesManager servicesManager;

    public WsFederationCredential createCredentialFromToken(Assertion assertion) {
        ZonedDateTime retrievedOn = ZonedDateTime.now();
        LOGGER.debug("Retrieved on [{}]", (Object)retrievedOn);
        WsFederationCredential credential = new WsFederationCredential();
        credential.setRetrievedOn(retrievedOn);
        credential.setId(assertion.getID());
        credential.setIssuer(assertion.getIssuer());
        credential.setIssuedOn(ZonedDateTime.parse(assertion.getIssueInstant().toDateTimeISO().toString()));
        Conditions conditions = assertion.getConditions();
        if (conditions != null) {
            credential.setNotBefore(ZonedDateTime.parse(conditions.getNotBefore().toDateTimeISO().toString()));
            credential.setNotOnOrAfter(ZonedDateTime.parse(conditions.getNotOnOrAfter().toDateTimeISO().toString()));
            if (!conditions.getAudienceRestrictionConditions().isEmpty()) {
                credential.setAudience(((Audience)((AudienceRestrictionCondition)conditions.getAudienceRestrictionConditions().get(0)).getAudiences().get(0)).getUri());
            }
        }
        if (!assertion.getAuthenticationStatements().isEmpty()) {
            credential.setAuthenticationMethod(((AuthenticationStatement)assertion.getAuthenticationStatements().get(0)).getAuthenticationMethod());
        }
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        assertion.getAttributeStatements().stream().flatMap(attributeStatement -> attributeStatement.getAttributes().stream()).forEach(item -> {
            LOGGER.debug("Processed attribute: [{}]", (Object)item.getAttributeName());
            List itemList = IntStream.range(0, item.getAttributeValues().size()).mapToObj(i -> ((XSAny)item.getAttributeValues().get(i)).getTextContent()).collect(Collectors.toList());
            if (!itemList.isEmpty()) {
                attributes.put(item.getAttributeName(), itemList);
            }
        });
        credential.setAttributes(attributes);
        LOGGER.debug("Credential: [{}]", (Object)credential);
        return credential;
    }

    public RequestedSecurityToken getRequestSecurityTokenFromResult(String wresult) {
        RequestedSecurityToken requestedSecurityToken;
        LOGGER.debug("Result token received from ADFS is [{}]", (Object)wresult);
        ByteArrayInputStream in = new ByteArrayInputStream(wresult.getBytes(StandardCharsets.UTF_8));
        Throwable throwable = null;
        try {
            LOGGER.debug("Parsing token into a document");
            Document document = this.configBean.getParserPool().parse((InputStream)in);
            Element metadataRoot = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = this.configBean.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(metadataRoot);
            if (unmarshaller == null) {
                throw new IllegalArgumentException("Unmarshaller for the metadata root element cannot be determined");
            }
            LOGGER.debug("Unmarshalling the document into a security token response");
            RequestSecurityTokenResponse rsToken = (RequestSecurityTokenResponse)unmarshaller.unmarshall(metadataRoot);
            if (rsToken.getRequestedSecurityToken() == null) {
                throw new IllegalArgumentException("Request security token response is null");
            }
            LOGGER.debug("Locating list of requested security tokens");
            List rst = rsToken.getRequestedSecurityToken();
            if (rst.isEmpty()) {
                throw new IllegalArgumentException("No requested security token response is provided in the response");
            }
            LOGGER.debug("Locating the first occurrence of a requested security token in the list");
            RequestedSecurityToken reqToken = (RequestedSecurityToken)rst.get(0);
            if (reqToken.getSecurityTokens() == null || reqToken.getSecurityTokens().isEmpty()) {
                throw new IllegalArgumentException("Requested security token response is not carrying any security tokens");
            }
            requestedSecurityToken = reqToken;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    WsFederationHelper.$closeResource(throwable, in);
                    throw throwable3;
                }
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        WsFederationHelper.$closeResource(throwable, in);
        return requestedSecurityToken;
    }

    public Pair<Assertion, WsFederationConfiguration> buildAndVerifyAssertion(RequestedSecurityToken reqToken, Collection<WsFederationConfiguration> config) {
        XMLObject securityToken = this.getSecurityTokenFromRequestedToken(reqToken, config);
        if (securityToken instanceof Assertion) {
            LOGGER.debug("Security token is an assertion.");
            Assertion assertion = (Assertion)Assertion.class.cast(securityToken);
            LOGGER.debug("Extracted assertion successfully: [{}]", (Object)assertion);
            WsFederationConfiguration cfg = config.stream().filter(c -> c.getIdentityProviderIdentifier().equals(assertion.getIssuer())).findFirst().orElse(null);
            if (cfg == null) {
                throw new IllegalArgumentException("Could not locate wsfed configuration for security token provided. The assertion issuer " + assertion.getIssuer() + " does not match any of the identity provider identifiers defined in the configuration");
            }
            return Pair.of((Object)assertion, (Object)cfg);
        }
        throw new IllegalArgumentException("Could not extract or decrypt an assertion based on the security token provided");
    }

    private XMLObject getSecurityTokenFromRequestedToken(RequestedSecurityToken reqToken, Collection<WsFederationConfiguration> config) {
        LOGGER.debug("Locating the first occurrence of a security token from the requested security token");
        XMLObject securityToken = this.getAssertionFromSecurityToken(reqToken);
        if (securityToken instanceof EncryptedData) {
            LOGGER.debug("Security token is encrypted. Attempting to decrypt to extract the assertion");
            EncryptedData encryptedData = (EncryptedData)EncryptedData.class.cast(securityToken);
            Iterator<WsFederationConfiguration> it = config.iterator();
            boolean found = false;
            while (!found && it.hasNext()) {
                try {
                    WsFederationConfiguration c = it.next();
                    Decrypter decrypter = WsFederationHelper.buildAssertionDecrypter(c);
                    LOGGER.debug("Built an instance of [{}]", (Object)decrypter.getClass().getName());
                    securityToken = decrypter.decryptData(encryptedData);
                    LOGGER.debug("Decrypted assertion successfully");
                    found = true;
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            if (!found) {
                throw new IllegalArgumentException("Could not extract or decrypt an assertion based on the security token provided");
            }
        }
        return securityToken;
    }

    public XMLObject getAssertionFromSecurityToken(RequestedSecurityToken reqToken) {
        return (XMLObject)reqToken.getSecurityTokens().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateSignature(Pair<Assertion, WsFederationConfiguration> assertion) {
        if (assertion == null || assertion.getKey() == null || assertion.getValue() == null) {
            LOGGER.warn("No assertion or its configuration was provided to validate signatures");
            return false;
        }
        boolean valid = false;
        Signature signature = ((Assertion)assertion.getKey()).getSignature();
        if (signature != null) {
            SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
            try {
                validator.validate(signature);
                CriteriaSet criteriaSet = new CriteriaSet();
                criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
                criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
                criteriaSet.add((Object)new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"));
                criteriaSet.add((Object)new EntityIdCriterion(((WsFederationConfiguration)assertion.getValue()).getIdentityProviderIdentifier()));
                try {
                    SignatureTrustEngine engine = WsFederationHelper.buildSignatureTrustEngine((WsFederationConfiguration)assertion.getValue());
                    valid = engine.validate((Object)signature, criteriaSet);
                }
                catch (SecurityException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (!valid) {
                        LOGGER.error("Signature doesn't match any signing credential.");
                    }
                }
            }
            catch (SignatureException e) {
                LOGGER.error("Failed to validate assertion signature", (Throwable)e);
            }
        }
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)((XMLObject)assertion.getKey()));
        return valid;
    }

    public String getRelyingPartyIdentifier(Service service, WsFederationConfiguration configuration) {
        String relyingPartyIdentifier = configuration.getRelyingPartyIdentifier();
        if (service != null) {
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            if (RegisteredServiceProperty.RegisteredServiceProperties.WSFED_RELYING_PARTY_ID.isAssignedTo(registeredService)) {
                relyingPartyIdentifier = RegisteredServiceProperty.RegisteredServiceProperties.WSFED_RELYING_PARTY_ID.getPropertyValue(registeredService).getValue();
            }
        }
        LOGGER.debug("Determined relying party identifier for service [{}] to be [{}]", (Object)service, (Object)relyingPartyIdentifier);
        return relyingPartyIdentifier;
    }

    private static SignatureTrustEngine buildSignatureTrustEngine(WsFederationConfiguration wsFederationConfiguration) {
        List<Credential> signingWallet = wsFederationConfiguration.getSigningWallet();
        StaticCredentialResolver resolver = new StaticCredentialResolver(signingWallet);
        StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver(signingWallet);
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)resolver, (KeyInfoCredentialResolver)keyResolver);
    }

    private static Credential getEncryptionCredential(WsFederationConfiguration config) {
        BasicX509Credential basicX509Credential;
        LOGGER.debug("Locating encryption credential private key [{}]", (Object)config.getEncryptionPrivateKey());
        BufferedReader br = new BufferedReader(new InputStreamReader(config.getEncryptionPrivateKey().getInputStream(), StandardCharsets.UTF_8));
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOGGER.debug("Parsing credential private key");
        PEMParser pemParser = new PEMParser((Reader)br);
        Throwable throwable = null;
        try {
            KeyPair kp;
            Object privateKeyPemObject = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
            if (privateKeyPemObject instanceof PEMEncryptedKeyPair) {
                LOGGER.debug("Encryption private key is an encrypted keypair");
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)privateKeyPemObject;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(config.getEncryptionPrivateKeyPassword().toCharArray());
                LOGGER.debug("Attempting to decrypt the encrypted keypair based on the provided encryption private key password");
                kp = converter.getKeyPair(ckp.decryptKeyPair(decProv));
            } else {
                LOGGER.debug("Extracting a keypair from the private key");
                kp = converter.getKeyPair((PEMKeyPair)privateKeyPemObject);
            }
            X509CertParser certParser = new X509CertParser();
            LOGGER.debug("Locating encryption certificate [{}]", (Object)config.getEncryptionCertificate());
            certParser.engineInit(config.getEncryptionCertificate().getInputStream());
            LOGGER.debug("Invoking certificate engine to parse the certificate [{}]", (Object)config.getEncryptionCertificate());
            X509CertificateObject cert = (X509CertificateObject)certParser.engineRead();
            LOGGER.debug("Creating final credential based on the certificate [{}] and the private key", (Object)cert.getIssuerDN());
            basicX509Credential = new BasicX509Credential((X509Certificate)cert, kp.getPrivate());
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                WsFederationHelper.$closeResource(throwable, (AutoCloseable)pemParser);
                throw throwable3;
            }
        }
        WsFederationHelper.$closeResource(throwable, (AutoCloseable)pemParser);
        return basicX509Credential;
    }

    private static Decrypter buildAssertionDecrypter(WsFederationConfiguration config) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new InlineEncryptedKeyResolver());
        list.add(new EncryptedElementTypeEncryptedKeyResolver());
        list.add(new SimpleRetrievalMethodEncryptedKeyResolver());
        LOGGER.debug("Built a list of encrypted key resolvers: [{}]", list);
        ChainingEncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(list);
        LOGGER.debug("Building credential instance to decrypt data");
        Credential encryptionCredential = WsFederationHelper.getEncryptionCredential(config);
        StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver(encryptionCredential);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)encryptedKeyResolver);
        decrypter.setRootInNewDocument(true);
        return decrypter;
    }

    @Generated
    public WsFederationHelper(OpenSamlConfigBean configBean, ServicesManager servicesManager) {
        this.configBean = configBean;
        this.servicesManager = servicesManager;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

