/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsFederationAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationAuthenticationHandler.class);

    public WsFederationAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory) {
        super(name, servicesManager, principalFactory, null);
    }

    public boolean supports(Credential credentials) {
        return credentials != null && WsFederationCredential.class.isAssignableFrom(credentials.getClass());
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        WsFederationCredential wsFederationCredentials = (WsFederationCredential)credential;
        if (wsFederationCredentials != null) {
            Map<String, List<Object>> attributes = wsFederationCredentials.getAttributes();
            Principal principal = this.principalFactory.createPrincipal(wsFederationCredentials.getId(), attributes);
            return this.createHandlerResult(wsFederationCredentials, principal, new ArrayList());
        }
        throw new FailedLoginException();
    }
}

