/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.config;

import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.WsFederationHelper;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieManager;
import org.apereo.cas.support.wsfederation.web.WsFederationNavigationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="wsFederationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class WsFederationAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationAuthenticationConfiguration.class);
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private OpenSamlConfigBean configBean;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="wsFederationConfigurations")
    private Collection<WsFederationConfiguration> wsFederationConfigurations;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    public WsFederationHelper wsFederationHelper() {
        return new WsFederationHelper(this.configBean, this.servicesManager);
    }

    @Bean
    public WsFederationCookieManager wsFederationCookieManager() {
        return new WsFederationCookieManager(this.wsFederationConfigurations, this.casProperties.getTheme().getParamName(), this.casProperties.getLocale().getParamName());
    }

    @Bean
    public WsFederationNavigationController wsFederationNavigationController() {
        return new WsFederationNavigationController(this.wsFederationCookieManager(), this.wsFederationHelper(), this.wsFederationConfigurations, this.authenticationRequestServiceSelectionStrategies, (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.casProperties.getServer().getLoginUrl());
    }
}

