/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.config.support.authentication;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationDelegatedCookieProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationDelegationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.wsfederation.WsFederationAttributeMutator;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.authentication.handler.support.WsFederationAuthenticationHandler;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredentialsToPrincipalResolver;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieCipherExecutor;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieGenerator;
import org.apereo.cas.web.support.CookieValueManager;
import org.apereo.cas.web.support.DefaultCasCookieValueManager;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Configuration(value="wsfedAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class WsFedAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFedAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    @Qualifier(value="attributeRepository")
    private IPersonAttributeDao attributeRepository;
    @Autowired(required=false)
    @Qualifier(value="wsfedAttributeMutator")
    private WsFederationAttributeMutator attributeMutator;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private CasConfigurationProperties casProperties;

    private WsFederationConfiguration getWsFederationConfiguration(WsFederationDelegationProperties wsfed) {
        Object cipher;
        WsFederationConfiguration config = new WsFederationConfiguration();
        config.setAttributesType(WsFederationConfiguration.WsFedPrincipalResolutionAttributesType.valueOf(wsfed.getAttributesType()));
        config.setIdentityAttribute(wsfed.getIdentityAttribute());
        config.setIdentityProviderIdentifier(wsfed.getIdentityProviderIdentifier());
        config.setIdentityProviderUrl(wsfed.getIdentityProviderUrl());
        config.setTolerance(Beans.newDuration((String)wsfed.getTolerance()).toMillis());
        config.setRelyingPartyIdentifier(wsfed.getRelyingPartyIdentifier());
        StringUtils.commaDelimitedListToSet((String)wsfed.getSigningCertificateResources()).forEach(s -> config.getSigningCertificateResources().add(this.resourceLoader.getResource(s)));
        StringUtils.commaDelimitedListToSet((String)wsfed.getEncryptionPrivateKey()).forEach(s -> config.setEncryptionPrivateKey(this.resourceLoader.getResource(s)));
        StringUtils.commaDelimitedListToSet((String)wsfed.getEncryptionCertificate()).forEach(s -> config.setEncryptionCertificate(this.resourceLoader.getResource(s)));
        config.setEncryptionPrivateKeyPassword(wsfed.getEncryptionPrivateKeyPassword());
        config.setAttributeMutator(this.attributeMutator);
        config.setAutoRedirect(wsfed.isAutoRedirect());
        config.setName(wsfed.getName());
        WsFederationDelegatedCookieProperties cookie = wsfed.getCookie();
        EncryptionJwtSigningJwtCryptographyProperties crypto = cookie.getCrypto();
        if (crypto.isEnabled()) {
            cipher = new WsFederationCookieCipherExecutor(crypto.getEncryption().getKey(), crypto.getSigning().getKey(), crypto.getAlg());
        } else {
            LOGGER.info("WsFederation delegated authentication cookie encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of delegated authentication cookie.");
            cipher = CipherExecutor.noOp();
        }
        WsFederationCookieGenerator cookieGen = new WsFederationCookieGenerator((CookieValueManager)new DefaultCasCookieValueManager(cipher, (CookieProperties)cookie), cookie.getName(), cookie.getPath(), cookie.getMaxAge(), cookie.isSecure(), cookie.getDomain(), cookie.isHttpOnly());
        config.setCookieGenerator(cookieGen);
        config.initialize();
        return config;
    }

    @ConditionalOnMissingBean(name={"wsFederationConfigurations"})
    @Bean
    @RefreshScope
    public Collection<WsFederationConfiguration> wsFederationConfigurations() {
        HashSet<WsFederationConfiguration> col = new HashSet<WsFederationConfiguration>();
        this.casProperties.getAuthn().getWsfed().forEach(wsfed -> {
            WsFederationConfiguration cfg = this.getWsFederationConfiguration((WsFederationDelegationProperties)wsfed);
            col.add(cfg);
        });
        return col;
    }

    @ConditionalOnMissingBean(name={"adfsPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory adfsPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"wsfedAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer wsfedAuthenticationEventExecutionPlanConfigurer() {
        return plan -> this.casProperties.getAuthn().getWsfed().stream().filter(wsfed -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wsfed.getIdentityProviderUrl()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wsfed.getIdentityProviderIdentifier())).forEach(wsfed -> {
            WsFederationAuthenticationHandler handler = new WsFederationAuthenticationHandler(wsfed.getName(), this.servicesManager, this.adfsPrincipalFactory());
            if (!wsfed.isAttributeResolverEnabled()) {
                plan.registerAuthenticationHandler((AuthenticationHandler)handler);
            } else {
                Collection<WsFederationConfiguration> configurations = this.wsFederationConfigurations();
                WsFederationConfiguration cfg = configurations.stream().filter(c -> c.getIdentityProviderUrl().equals(wsfed.getIdentityProviderUrl())).findFirst().orElseThrow(() -> new RuntimeException("Unable to find configuration for identity provider " + wsfed.getIdentityProviderUrl()));
                WsFederationCredentialsToPrincipalResolver r = new WsFederationCredentialsToPrincipalResolver(this.attributeRepository, this.adfsPrincipalFactory(), wsfed.getPrincipal().isReturnNull(), wsfed.getPrincipal().getPrincipalAttribute(), cfg);
                plan.registerAuthenticationHandlerWithPrincipalResolver((AuthenticationHandler)handler, (PrincipalResolver)r);
            }
        });
    }
}

