/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredential;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsFederationCredentialsToPrincipalResolver
extends PersonDirectoryPrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationCredentialsToPrincipalResolver.class);
    private final WsFederationConfiguration configuration;

    public WsFederationCredentialsToPrincipalResolver(IPersonAttributeDao attributeRepository, PrincipalFactory principalFactory, boolean returnNullIfNoAttributes, String principalAttributeName, WsFederationConfiguration configuration) {
        super(attributeRepository, principalFactory, returnNullIfNoAttributes, principalAttributeName);
        this.configuration = configuration;
    }

    protected String extractPrincipalId(Credential credentials, Optional<Principal> currentPrincipal) {
        WsFederationCredential wsFedCredentials = (WsFederationCredential)credentials;
        Map<String, List<Object>> attributes = wsFedCredentials.getAttributes();
        LOGGER.debug("Credential attributes provided are: [{}]", attributes);
        String idAttribute = this.configuration.getIdentityAttribute();
        if (attributes.containsKey(idAttribute)) {
            LOGGER.debug("Extracting principal id from attribute [{}]", (Object)this.configuration.getIdentityAttribute());
            Set idAttributeAsList = CollectionUtils.toCollection(attributes.get(this.configuration.getIdentityAttribute()));
            if (idAttributeAsList.size() > 1) {
                LOGGER.warn("Found multiple values for id attribute [{}].", (Object)idAttribute);
            } else {
                LOGGER.debug("Found principal id attribute as [{}]", (Object)idAttributeAsList);
            }
            Optional result = CollectionUtils.firstElement((Object)idAttributeAsList);
            if (result.isPresent()) {
                String principalId = result.get().toString();
                LOGGER.debug("Principal Id extracted from credentials: [{}]", (Object)principalId);
                return principalId;
            }
        }
        LOGGER.warn("Credential attributes do not include an attribute for [{}]. This will prohibit CAS to construct a meaningful authenticated principal. Examine the released claims and ensure [{}] is allowed", (Object)idAttribute, (Object)idAttribute);
        return null;
    }

    protected Map<String, List<Object>> retrievePersonAttributes(String principalId, Credential credential) {
        WsFederationCredential wsFedCredentials = (WsFederationCredential)credential;
        if (this.configuration.getAttributesType() == WsFederationConfiguration.WsFedPrincipalResolutionAttributesType.WSFED) {
            return wsFedCredentials.getAttributes();
        }
        if (this.configuration.getAttributesType() == WsFederationConfiguration.WsFedPrincipalResolutionAttributesType.CAS) {
            return super.retrievePersonAttributes(principalId, credential);
        }
        HashMap<String, List<Object>> mergedAttributes = new HashMap<String, List<Object>>(wsFedCredentials.getAttributes());
        mergedAttributes.putAll(super.retrievePersonAttributes(principalId, credential));
        return mergedAttributes;
    }

    public boolean supports(Credential credential) {
        return credential != null && WsFederationCredential.class.isAssignableFrom(credential.getClass());
    }

    @Generated
    public String toString() {
        return "WsFederationCredentialsToPrincipalResolver(super=" + super.toString() + ", configuration=" + this.configuration + ")";
    }
}

