/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.authentication.principal;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsFederationCredential
implements Credential {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationCredential.class);
    private static final long serialVersionUID = -824605020472810939L;
    private String audience;
    private String authenticationMethod;
    private String id;
    private String issuer;
    private ZonedDateTime issuedOn;
    private ZonedDateTime notBefore;
    private ZonedDateTime notOnOrAfter;
    private ZonedDateTime retrievedOn;
    private Map<String, List<Object>> attributes;

    public boolean isValid(String expectedAudience, String expectedIssuer, long timeDrift) {
        if (!this.audience.equalsIgnoreCase(expectedAudience)) {
            LOGGER.warn("Audience [{}] is invalid where the expected audience should be [{}]", (Object)this.audience, (Object)expectedAudience);
            return false;
        }
        if (!this.issuer.equalsIgnoreCase(expectedIssuer)) {
            LOGGER.warn("Issuer [{}] is invalid since the expected issuer should be [{}]", (Object)this.issuer, (Object)expectedIssuer);
            return false;
        }
        ZonedDateTime retrievedOnTimeDrift = this.getRetrievedOn().minus(timeDrift, ChronoUnit.MILLIS);
        if (this.issuedOn.isBefore(retrievedOnTimeDrift)) {
            LOGGER.warn("Ticket is issued before the allowed drift. Issued on [{}] while allowed drift is [{}]", (Object)this.issuedOn, (Object)retrievedOnTimeDrift);
            return false;
        }
        ZonedDateTime retrievedOnTimeAfterDrift = this.retrievedOn.plus(timeDrift, ChronoUnit.MILLIS);
        if (this.issuedOn.isAfter(retrievedOnTimeAfterDrift)) {
            LOGGER.warn("Ticket is issued after the allowed drift. Issued on [{}] while allowed drift is [{}]", (Object)this.issuedOn, (Object)retrievedOnTimeAfterDrift);
            return false;
        }
        if (this.retrievedOn.isAfter(this.notOnOrAfter)) {
            LOGGER.warn("Ticket is too late because it's retrieved on [{}] which is after [{}].", (Object)this.retrievedOn, (Object)this.notOnOrAfter);
            return false;
        }
        LOGGER.debug("WsFed Credential is validated for [{}] and [{}].", (Object)expectedAudience, (Object)expectedIssuer);
        return true;
    }

    @Generated
    public String toString() {
        return "WsFederationCredential(audience=" + this.audience + ", authenticationMethod=" + this.authenticationMethod + ", id=" + this.id + ", issuer=" + this.issuer + ", issuedOn=" + this.issuedOn + ", notBefore=" + this.notBefore + ", notOnOrAfter=" + this.notOnOrAfter + ", retrievedOn=" + this.retrievedOn + ", attributes=" + this.attributes + ")";
    }

    @Generated
    public void setAudience(String audience) {
        this.audience = audience;
    }

    @Generated
    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setIssuedOn(ZonedDateTime issuedOn) {
        this.issuedOn = issuedOn;
    }

    @Generated
    public void setNotBefore(ZonedDateTime notBefore) {
        this.notBefore = notBefore;
    }

    @Generated
    public void setNotOnOrAfter(ZonedDateTime notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter;
    }

    @Generated
    public void setRetrievedOn(ZonedDateTime retrievedOn) {
        this.retrievedOn = retrievedOn;
    }

    @Generated
    public void setAttributes(Map<String, List<Object>> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getAudience() {
        return this.audience;
    }

    @Generated
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public ZonedDateTime getIssuedOn() {
        return this.issuedOn;
    }

    @Generated
    public ZonedDateTime getNotBefore() {
        return this.notBefore;
    }

    @Generated
    public ZonedDateTime getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    @Generated
    public ZonedDateTime getRetrievedOn() {
        return this.retrievedOn;
    }

    @Generated
    public Map<String, List<Object>> getAttributes() {
        return this.attributes;
    }

    @Generated
    public WsFederationCredential() {
    }

    @Generated
    public WsFederationCredential(String audience, String authenticationMethod, String id, String issuer, ZonedDateTime issuedOn, ZonedDateTime notBefore, ZonedDateTime notOnOrAfter, ZonedDateTime retrievedOn, Map<String, List<Object>> attributes) {
        this.audience = audience;
        this.authenticationMethod = authenticationMethod;
        this.id = id;
        this.issuer = issuer;
        this.issuedOn = issuedOn;
        this.notBefore = notBefore;
        this.notOnOrAfter = notOnOrAfter;
        this.retrievedOn = retrievedOn;
        this.attributes = attributes;
    }
}

