/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.config.support.authentication;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationDelegatedCookieProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationDelegationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.attributes.GroovyWsFederationAttributeMutator;
import org.apereo.cas.support.wsfederation.attributes.WsFederationAttributeMutator;
import org.apereo.cas.support.wsfederation.authentication.handler.support.WsFederationAuthenticationHandler;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredentialsToPrincipalResolver;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieCipherExecutor;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieGenerator;
import org.apereo.cas.web.support.DefaultCasCookieValueManager;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Configuration(value="wsfedAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class WsFedAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFedAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    @Qualifier(value="attributeRepository")
    private ObjectProvider<IPersonAttributeDao> attributeRepository;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private CasConfigurationProperties casProperties;

    private WsFederationConfiguration getWsFederationConfiguration(WsFederationDelegationProperties wsfed) {
        WsFederationConfiguration config = new WsFederationConfiguration();
        config.setAttributesType(WsFederationConfiguration.WsFedPrincipalResolutionAttributesType.valueOf(wsfed.getAttributesType()));
        config.setIdentityAttribute(wsfed.getIdentityAttribute());
        config.setIdentityProviderIdentifier(wsfed.getIdentityProviderIdentifier());
        config.setIdentityProviderUrl(wsfed.getIdentityProviderUrl());
        config.setTolerance(Beans.newDuration((String)wsfed.getTolerance()).toMillis());
        config.setRelyingPartyIdentifier(wsfed.getRelyingPartyIdentifier());
        StringUtils.commaDelimitedListToSet((String)wsfed.getSigningCertificateResources()).forEach(s -> config.getSigningCertificateResources().add(this.resourceLoader.getResource(s)));
        StringUtils.commaDelimitedListToSet((String)wsfed.getEncryptionPrivateKey()).forEach(s -> config.setEncryptionPrivateKey(this.resourceLoader.getResource(s)));
        StringUtils.commaDelimitedListToSet((String)wsfed.getEncryptionCertificate()).forEach(s -> config.setEncryptionCertificate(this.resourceLoader.getResource(s)));
        config.setEncryptionPrivateKeyPassword(wsfed.getEncryptionPrivateKeyPassword());
        config.setAttributeMutator(WsFedAuthenticationEventExecutionPlanConfiguration.getAttributeMutatorForWsFederationConfig(wsfed));
        config.setAutoRedirect(wsfed.isAutoRedirect());
        config.setName(wsfed.getName());
        config.setCookieGenerator(WsFedAuthenticationEventExecutionPlanConfiguration.getCookieGeneratorForWsFederationConfig(wsfed));
        config.initialize();
        return config;
    }

    private static WsFederationAttributeMutator getAttributeMutatorForWsFederationConfig(WsFederationDelegationProperties wsfed) {
        Resource location = wsfed.getAttributeMutatorScript().getLocation();
        if (location != null) {
            return new GroovyWsFederationAttributeMutator(location);
        }
        return WsFederationAttributeMutator.noOp();
    }

    private static WsFederationCookieGenerator getCookieGeneratorForWsFederationConfig(WsFederationDelegationProperties wsfed) {
        WsFederationDelegatedCookieProperties cookie = wsfed.getCookie();
        CipherExecutor cipher = WsFedAuthenticationEventExecutionPlanConfiguration.getCipherExecutorForWsFederationConfig(cookie);
        return new WsFederationCookieGenerator(new DefaultCasCookieValueManager(cipher, (CookieProperties)cookie), (CookieProperties)cookie);
    }

    private static CipherExecutor getCipherExecutorForWsFederationConfig(WsFederationDelegatedCookieProperties cookie) {
        EncryptionJwtSigningJwtCryptographyProperties crypto = cookie.getCrypto();
        if (crypto.isEnabled()) {
            return new WsFederationCookieCipherExecutor(crypto.getEncryption().getKey(), crypto.getSigning().getKey(), crypto.getAlg(), crypto.getSigning().getKeySize(), crypto.getEncryption().getKeySize());
        }
        LOGGER.info("WsFederation delegated authentication cookie encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of delegated authentication cookie.");
        return CipherExecutor.noOp();
    }

    @ConditionalOnMissingBean(name={"wsFederationConfigurations"})
    @Bean
    @RefreshScope
    public Collection<WsFederationConfiguration> wsFederationConfigurations() {
        HashSet<WsFederationConfiguration> col = new HashSet<WsFederationConfiguration>();
        this.casProperties.getAuthn().getWsfed().forEach(wsfed -> {
            WsFederationConfiguration cfg = this.getWsFederationConfiguration((WsFederationDelegationProperties)wsfed);
            col.add(cfg);
        });
        return col;
    }

    @ConditionalOnMissingBean(name={"wsfedPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory wsfedPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"wsfedAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer wsfedAuthenticationEventExecutionPlanConfigurer() {
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        return plan -> this.casProperties.getAuthn().getWsfed().stream().filter(wsfed -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wsfed.getIdentityProviderUrl()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wsfed.getIdentityProviderIdentifier())).forEach(wsfed -> {
            WsFederationAuthenticationHandler handler = new WsFederationAuthenticationHandler(wsfed.getName(), (ServicesManager)this.servicesManager.getIfAvailable(), this.wsfedPrincipalFactory(), wsfed.getOrder());
            if (!wsfed.isAttributeResolverEnabled()) {
                plan.registerAuthenticationHandler((AuthenticationHandler)handler);
            } else {
                Collection<WsFederationConfiguration> configurations = this.wsFederationConfigurations();
                WsFederationConfiguration cfg = configurations.stream().filter(c -> c.getIdentityProviderUrl().equals(wsfed.getIdentityProviderUrl())).findFirst().orElseThrow(() -> new RuntimeException("Unable to find configuration for identity provider " + wsfed.getIdentityProviderUrl()));
                PersonDirectoryPrincipalResolverProperties principal = wsfed.getPrincipal();
                String principalAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)principal.getPrincipalAttribute(), (CharSequence)personDirectory.getPrincipalAttribute());
                WsFederationCredentialsToPrincipalResolver r = new WsFederationCredentialsToPrincipalResolver((IPersonAttributeDao)this.attributeRepository.getIfAvailable(), this.wsfedPrincipalFactory(), principal.isReturnNull() || personDirectory.isReturnNull(), principalAttribute, cfg, personDirectory.isUseExistingPrincipalId() || principal.isUseExistingPrincipalId());
                plan.registerAuthenticationHandlerWithPrincipalResolver((AuthenticationHandler)handler, (PrincipalResolver)r);
            }
        });
    }
}

