/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.web;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieSerializer;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class WsFederationCookieManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationCookieManager.class);
    public static final String WCTX = "wctx";
    private final Collection<WsFederationConfiguration> configurations;
    private final String themeParamName;
    private final String localParamName;
    private final WsFederationCookieSerializer serializer = new WsFederationCookieSerializer();

    public Service retrieve(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String wCtx = request.getParameter(WCTX);
        LOGGER.debug("Parameter [{}] received: [{}]", (Object)WCTX, (Object)wCtx);
        if (StringUtils.isBlank((CharSequence)wCtx)) {
            LOGGER.error("No [{}] parameter is found", (Object)WCTX);
            throw new IllegalArgumentException("No wctx parameter is found");
        }
        WsFederationConfiguration configuration = this.configurations.stream().filter(c -> c.getId().equalsIgnoreCase(wCtx)).findFirst().orElse(null);
        CookieRetrievingCookieGenerator cookieGen = configuration.getCookieGenerator();
        String value = cookieGen.retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.error("No cookie value could be retrieved to determine the state of the delegated authentication session");
            throw new IllegalArgumentException("No cookie could be found to determine session state");
        }
        String blob = EncodingUtils.hexDecode((String)value);
        Map session = (Map)this.serializer.from(blob);
        request.setAttribute(this.themeParamName, session.get(this.themeParamName));
        request.setAttribute(this.localParamName, session.get(this.localParamName));
        request.setAttribute("method", session.get("method"));
        String serviceKey = "service-" + wCtx;
        Service service = (Service)session.get(serviceKey);
        LOGGER.debug("Located service [{}] from session cookie", (Object)service);
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        return service;
    }

    public void store(HttpServletRequest request, HttpServletResponse response, String wctx, Service service, WsFederationConfiguration configuration) {
        Object theme;
        Object locale;
        HashMap<String, Object> session = new HashMap<String, Object>();
        session.put("service-" + wctx, service);
        String methods = request.getParameter("method");
        if (StringUtils.isNotBlank((CharSequence)methods)) {
            session.put("method-" + wctx, methods);
        }
        if ((locale = request.getAttribute(this.localParamName)) != null) {
            session.put(this.localParamName + "-" + wctx, locale);
        }
        if ((theme = request.getAttribute(this.themeParamName)) != null) {
            session.put(this.themeParamName + "-" + wctx, theme);
        }
        String cookieValue = this.serializeSessionValues(session);
        CookieRetrievingCookieGenerator cookieGen = configuration.getCookieGenerator();
        cookieGen.addCookie(request, response, cookieValue);
    }

    private String serializeSessionValues(Map<String, Object> attributes) {
        String blob = this.serializer.toString(attributes);
        return EncodingUtils.hexEncode((String)blob);
    }

    @Generated
    public WsFederationCookieManager(Collection<WsFederationConfiguration> configurations, String themeParamName, String localParamName) {
        this.configurations = configurations;
        this.themeParamName = themeParamName;
        this.localParamName = localParamName;
    }
}

