/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation;

import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.wsfederation.attributes.WsFederationAttributeMutator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.jooq.lambda.Unchecked;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class WsFederationConfiguration
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationConfiguration.class);
    private static final long serialVersionUID = 2310859477512242659L;
    private static final String QUERYSTRING = "?wa=wsignin1.0&wtrealm=%s&wctx=%s";
    private transient Resource encryptionPrivateKey;
    private transient Resource encryptionCertificate;
    private String encryptionPrivateKeyPassword;
    private String identityAttribute;
    private String identityProviderIdentifier;
    private String identityProviderUrl;
    private transient List<Resource> signingCertificateResources = new ArrayList<Resource>(0);
    private String relyingPartyIdentifier;
    private long tolerance;
    private boolean autoRedirect;
    private WsFedPrincipalResolutionAttributesType attributesType;
    private WsFederationAttributeMutator attributeMutator;
    private transient List<Credential> signingWallet;
    private String name;
    private String id = UUID.randomUUID().toString();
    private transient CasCookieBuilder cookieGenerator;

    public String getName() {
        return StringUtils.isBlank((CharSequence)this.name) ? this.getClass().getSimpleName() : this.name;
    }

    public void initialize() {
        this.signingCertificateResources.forEach(Unchecked.consumer(r -> {
            try {
                FileWatcherService watcher = new FileWatcherService(r.getFile(), file -> this.createSigningWallet(this.signingCertificateResources));
                watcher.start(this.getClass().getSimpleName());
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }));
        this.createSigningWallet(this.signingCertificateResources);
    }

    public List<Credential> getSigningWallet() {
        if (this.signingWallet == null) {
            this.createSigningWallet(this.signingCertificateResources);
        }
        return this.signingWallet;
    }

    public void setSigningCertificateResources(Resource ... signingCertificateResources) {
        this.signingCertificateResources = CollectionUtils.wrapList((Object[])signingCertificateResources);
        this.createSigningWallet(this.signingCertificateResources);
    }

    public String getAuthorizationUrl(String relyingPartyIdentifier, String wctx) {
        return String.format(this.getIdentityProviderUrl() + QUERYSTRING, relyingPartyIdentifier, wctx);
    }

    private static Credential getSigningCredential(Resource resource) {
        BasicX509Credential basicX509Credential;
        block8: {
            InputStream inputStream = resource.getInputStream();
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                BasicX509Credential publicCredential = new BasicX509Credential(certificate);
                LOGGER.debug("Signing credential key retrieved from [{}].", (Object)resource);
                basicX509Credential = publicCredential;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
                    return null;
                }
            }
            inputStream.close();
        }
        return basicX509Credential;
    }

    private void createSigningWallet(List<Resource> signingCertificateFiles) {
        this.signingWallet = signingCertificateFiles.stream().map(WsFederationConfiguration::getSigningCredential).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    public Resource getEncryptionPrivateKey() {
        return this.encryptionPrivateKey;
    }

    @Generated
    public Resource getEncryptionCertificate() {
        return this.encryptionCertificate;
    }

    @Generated
    public String getEncryptionPrivateKeyPassword() {
        return this.encryptionPrivateKeyPassword;
    }

    @Generated
    public String getIdentityAttribute() {
        return this.identityAttribute;
    }

    @Generated
    public String getIdentityProviderIdentifier() {
        return this.identityProviderIdentifier;
    }

    @Generated
    public String getIdentityProviderUrl() {
        return this.identityProviderUrl;
    }

    @Generated
    public List<Resource> getSigningCertificateResources() {
        return this.signingCertificateResources;
    }

    @Generated
    public String getRelyingPartyIdentifier() {
        return this.relyingPartyIdentifier;
    }

    @Generated
    public long getTolerance() {
        return this.tolerance;
    }

    @Generated
    public boolean isAutoRedirect() {
        return this.autoRedirect;
    }

    @Generated
    public WsFedPrincipalResolutionAttributesType getAttributesType() {
        return this.attributesType;
    }

    @Generated
    public WsFederationAttributeMutator getAttributeMutator() {
        return this.attributeMutator;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public CasCookieBuilder getCookieGenerator() {
        return this.cookieGenerator;
    }

    @Generated
    public void setEncryptionPrivateKey(Resource encryptionPrivateKey) {
        this.encryptionPrivateKey = encryptionPrivateKey;
    }

    @Generated
    public void setEncryptionCertificate(Resource encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
    }

    @Generated
    public void setEncryptionPrivateKeyPassword(String encryptionPrivateKeyPassword) {
        this.encryptionPrivateKeyPassword = encryptionPrivateKeyPassword;
    }

    @Generated
    public void setIdentityAttribute(String identityAttribute) {
        this.identityAttribute = identityAttribute;
    }

    @Generated
    public void setIdentityProviderIdentifier(String identityProviderIdentifier) {
        this.identityProviderIdentifier = identityProviderIdentifier;
    }

    @Generated
    public void setIdentityProviderUrl(String identityProviderUrl) {
        this.identityProviderUrl = identityProviderUrl;
    }

    @Generated
    public void setRelyingPartyIdentifier(String relyingPartyIdentifier) {
        this.relyingPartyIdentifier = relyingPartyIdentifier;
    }

    @Generated
    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }

    @Generated
    public void setAutoRedirect(boolean autoRedirect) {
        this.autoRedirect = autoRedirect;
    }

    @Generated
    public void setAttributesType(WsFedPrincipalResolutionAttributesType attributesType) {
        this.attributesType = attributesType;
    }

    @Generated
    public void setAttributeMutator(WsFederationAttributeMutator attributeMutator) {
        this.attributeMutator = attributeMutator;
    }

    @Generated
    public void setSigningWallet(List<Credential> signingWallet) {
        this.signingWallet = signingWallet;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCookieGenerator(CasCookieBuilder cookieGenerator) {
        this.cookieGenerator = cookieGenerator;
    }

    public static enum WsFedPrincipalResolutionAttributesType {
        CAS,
        WSFED,
        BOTH;

    }
}

