/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.config;

import java.util.Collection;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.WsFederationHelper;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieManager;
import org.apereo.cas.support.wsfederation.web.WsFederationNavigationController;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="wsFederationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class WsFederationAuthenticationConfiguration {
    @Autowired
    @Qualifier(value="shibboleth.OpenSAMLConfig")
    private ObjectProvider<OpenSamlConfigBean> configBean;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="wsFederationConfigurations")
    private Collection<WsFederationConfiguration> wsFederationConfigurations;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ObjectProvider<ServiceFactory> webApplicationServiceFactory;
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"wsFederationHelper"})
    public WsFederationHelper wsFederationHelper() {
        return new WsFederationHelper((OpenSamlConfigBean)this.configBean.getObject(), (ServicesManager)this.servicesManager.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"wsFederationCookieManager"})
    public WsFederationCookieManager wsFederationCookieManager() {
        return new WsFederationCookieManager(this.wsFederationConfigurations, this.casProperties.getTheme().getParamName(), this.casProperties.getLocale().getParamName());
    }

    @Bean
    public WsFederationNavigationController wsFederationNavigationController() {
        return new WsFederationNavigationController(this.wsFederationCookieManager(), this.wsFederationHelper(), this.wsFederationConfigurations, (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject(), (ServiceFactory<WebApplicationService>)((ServiceFactory)this.webApplicationServiceFactory.getObject()), this.casProperties.getServer().getLoginUrl());
    }
}

