/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.web;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.WsFederationHelper;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieManager;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="wsFederationNavigationController")
@RequestMapping
public class WsFederationNavigationController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationNavigationController.class);
    public static final String ENDPOINT_REDIRECT = "/wsfedredirect";
    public static final String PARAMETER_NAME = "wsfedclientid";
    private final WsFederationCookieManager wsFederationCookieManager;
    private final WsFederationHelper wsFederationHelper;
    private final Collection<WsFederationConfiguration> configurations;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final String casLoginEndpoint;

    @GetMapping(value={"/wsfedredirect"})
    public View redirectToProvider(HttpServletRequest request, HttpServletResponse response) {
        String wsfedId = request.getParameter(PARAMETER_NAME);
        try {
            WsFederationConfiguration cfg = this.configurations.stream().filter(c -> c.getId().equals(wsfedId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not locate WsFederation configuration for " + wsfedId));
            Service service = this.determineService(request);
            String id = this.wsFederationHelper.getRelyingPartyIdentifier(service, cfg);
            String url = cfg.getAuthorizationUrl(id, cfg.getId());
            this.wsFederationCookieManager.store(request, response, cfg.getId(), service, cfg);
            return new RedirectView(url);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
    }

    private Service determineService(HttpServletRequest request) {
        String serviceParameter = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("service"), (CharSequence)this.casLoginEndpoint);
        return this.authenticationRequestServiceSelectionStrategies.resolveService(this.webApplicationServiceFactory.createService(serviceParameter));
    }

    @Generated
    public WsFederationNavigationController(WsFederationCookieManager wsFederationCookieManager, WsFederationHelper wsFederationHelper, Collection<WsFederationConfiguration> configurations, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, ServiceFactory<WebApplicationService> webApplicationServiceFactory, String casLoginEndpoint) {
        this.wsFederationCookieManager = wsFederationCookieManager;
        this.wsFederationHelper = wsFederationHelper;
        this.configurations = configurations;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.casLoginEndpoint = casLoginEndpoint;
    }
}

