/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation;

import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.delegation.DelegationAutoRedirectTypes;
import org.apereo.cas.support.wsfederation.attributes.WsFederationAttributeMutator;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.springframework.core.io.Resource;

public class WsFederationConfiguration
implements Serializable {
    private static final long serialVersionUID = 2310859477512242659L;
    private static final String QUERYSTRING = "?wa=wsignin1.0&wtrealm=%s&wctx=%s";
    private transient Resource encryptionPrivateKey;
    private transient Resource encryptionCertificate;
    private String encryptionPrivateKeyPassword;
    private String identityAttribute;
    private String identityProviderIdentifier;
    private String identityProviderUrl;
    private String relyingPartyIdentifier;
    private long tolerance;
    private DelegationAutoRedirectTypes autoRedirectType = DelegationAutoRedirectTypes.NONE;
    private WsFedPrincipalResolutionAttributesType attributesType;
    private WsFederationAttributeMutator attributeMutator;
    private String name;
    private String id = UUID.randomUUID().toString();
    private transient CasCookieBuilder cookieGenerator;
    private String signingCertificates;

    public String getAuthorizationUrl(String relyingPartyIdentifier, String wctx) {
        return String.format(this.getIdentityProviderUrl() + QUERYSTRING, relyingPartyIdentifier, wctx);
    }

    public String getName() {
        return StringUtils.isBlank((CharSequence)this.name) ? this.getClass().getSimpleName() : this.name;
    }

    @Generated
    public Resource getEncryptionPrivateKey() {
        return this.encryptionPrivateKey;
    }

    @Generated
    public Resource getEncryptionCertificate() {
        return this.encryptionCertificate;
    }

    @Generated
    public String getEncryptionPrivateKeyPassword() {
        return this.encryptionPrivateKeyPassword;
    }

    @Generated
    public String getIdentityAttribute() {
        return this.identityAttribute;
    }

    @Generated
    public String getIdentityProviderIdentifier() {
        return this.identityProviderIdentifier;
    }

    @Generated
    public String getIdentityProviderUrl() {
        return this.identityProviderUrl;
    }

    @Generated
    public String getRelyingPartyIdentifier() {
        return this.relyingPartyIdentifier;
    }

    @Generated
    public long getTolerance() {
        return this.tolerance;
    }

    @Generated
    public DelegationAutoRedirectTypes getAutoRedirectType() {
        return this.autoRedirectType;
    }

    @Generated
    public WsFedPrincipalResolutionAttributesType getAttributesType() {
        return this.attributesType;
    }

    @Generated
    public WsFederationAttributeMutator getAttributeMutator() {
        return this.attributeMutator;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public CasCookieBuilder getCookieGenerator() {
        return this.cookieGenerator;
    }

    @Generated
    public String getSigningCertificates() {
        return this.signingCertificates;
    }

    @Generated
    public void setEncryptionPrivateKey(Resource encryptionPrivateKey) {
        this.encryptionPrivateKey = encryptionPrivateKey;
    }

    @Generated
    public void setEncryptionCertificate(Resource encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
    }

    @Generated
    public void setEncryptionPrivateKeyPassword(String encryptionPrivateKeyPassword) {
        this.encryptionPrivateKeyPassword = encryptionPrivateKeyPassword;
    }

    @Generated
    public void setIdentityAttribute(String identityAttribute) {
        this.identityAttribute = identityAttribute;
    }

    @Generated
    public void setIdentityProviderIdentifier(String identityProviderIdentifier) {
        this.identityProviderIdentifier = identityProviderIdentifier;
    }

    @Generated
    public void setIdentityProviderUrl(String identityProviderUrl) {
        this.identityProviderUrl = identityProviderUrl;
    }

    @Generated
    public void setRelyingPartyIdentifier(String relyingPartyIdentifier) {
        this.relyingPartyIdentifier = relyingPartyIdentifier;
    }

    @Generated
    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }

    @Generated
    public void setAutoRedirectType(DelegationAutoRedirectTypes autoRedirectType) {
        this.autoRedirectType = autoRedirectType;
    }

    @Generated
    public void setAttributesType(WsFedPrincipalResolutionAttributesType attributesType) {
        this.attributesType = attributesType;
    }

    @Generated
    public void setAttributeMutator(WsFederationAttributeMutator attributeMutator) {
        this.attributeMutator = attributeMutator;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCookieGenerator(CasCookieBuilder cookieGenerator) {
        this.cookieGenerator = cookieGenerator;
    }

    @Generated
    public void setSigningCertificates(String signingCertificates) {
        this.signingCertificates = signingCertificates;
    }

    public static enum WsFedPrincipalResolutionAttributesType {
        CAS,
        WSFED,
        BOTH;

    }
}

