/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.CasFeatureModule;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.WsFederationHelper;
import org.apereo.cas.support.wsfederation.services.WSFederationAuthenticationServiceRegistry;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieManager;
import org.apereo.cas.support.wsfederation.web.WsFederationNavigationController;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeature;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeature(feature=CasFeatureModule.FeatureCatalog.WsFederation)
@AutoConfiguration
public class WsFederationAuthenticationConfiguration {

    @Configuration(value="WsFederationAuthenticationControllerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WsFederationAuthenticationControllerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public WsFederationNavigationController wsFederationNavigationController(@Qualifier(value="wsFederationConfigurations") BeanContainer<WsFederationConfiguration> wsFederationConfigurations, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, CasConfigurationProperties casProperties, @Qualifier(value="wsFederationCookieManager") WsFederationCookieManager wsFederationCookieManager, @Qualifier(value="wsFederationHelper") WsFederationHelper wsFederationHelper, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
            return new WsFederationNavigationController(wsFederationCookieManager, wsFederationHelper, wsFederationConfigurations.toList(), authenticationRequestServiceSelectionStrategies, webApplicationServiceFactory, casProperties.getServer().getLoginUrl(), argumentExtractor);
        }
    }

    @Configuration(value="WsFederationAuthenticationCookieConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WsFederationAuthenticationCookieConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationCookieManager"})
        public WsFederationCookieManager wsFederationCookieManager(@Qualifier(value="wsFederationConfigurations") BeanContainer<WsFederationConfiguration> wsFederationConfigurations, CasConfigurationProperties casProperties) {
            return new WsFederationCookieManager(wsFederationConfigurations.toList(), casProperties.getTheme().getParamName(), casProperties.getLocale().getParamName());
        }
    }

    @Configuration(value="WsFederationAuthenticationHelperConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WsFederationAuthenticationHelperConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationHelper"})
        public WsFederationHelper wsFederationHelper(@Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean configBean, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new WsFederationHelper(configBean, servicesManager);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"wsFederationAuthenticationServiceRegistryExecutionPlanConfigurer"})
        public ServiceRegistryExecutionPlanConfigurer wsFederationAuthenticationServiceRegistryExecutionPlanConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return plan -> {
                CasRegisteredService service = new CasRegisteredService();
                service.setId(RandomUtils.nextLong());
                service.setEvaluationOrder(Integer.MIN_VALUE);
                service.setName(service.getClass().getSimpleName());
                service.setDescription("WS-Federation Authentication Request");
                service.setServiceId("^".concat(casProperties.getServer().getPrefix()).concat(".+"));
                plan.registerServiceRegistry((ServiceRegistry)new WSFederationAuthenticationServiceRegistry(applicationContext, new RegisteredService[]{service}));
            };
        }
    }
}

