/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.cookie.PinnableCookieProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationDelegatedCookieProperties;
import org.apereo.cas.configuration.model.support.wsfed.WsFederationDelegationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.attributes.GroovyWsFederationAttributeMutator;
import org.apereo.cas.support.wsfederation.attributes.WsFederationAttributeMutator;
import org.apereo.cas.support.wsfederation.authentication.handler.support.WsFederationAuthenticationHandler;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredentialsToPrincipalResolver;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieCipherExecutor;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieGenerator;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.mgmr.DefaultCasCookieValueManager;
import org.apereo.cas.web.support.mgmr.DefaultCookieSameSitePolicy;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WsFederation})
@AutoConfiguration
public class WsFedAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFedAuthenticationEventExecutionPlanConfiguration.class);

    @Configuration(value="WsFedAuthenticationEventExecutionPlanBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WsFedAuthenticationEventExecutionPlanBaseConfiguration {
        @ConditionalOnMissingBean(name={"wsfedAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer wsfedAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, CasConfigurationProperties casProperties, @Qualifier(value="wsfedPrincipalFactory") PrincipalFactory wsfedPrincipalFactory, @Qualifier(value="wsFederationConfigurations") BeanContainer<WsFederationConfiguration> wsFederationConfigurations, @Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
            return plan -> casProperties.getAuthn().getWsfed().stream().filter(wsfed -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wsfed.getIdentityProviderUrl()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wsfed.getIdentityProviderIdentifier())).forEach(wsfed -> {
                WsFederationAuthenticationHandler handler = new WsFederationAuthenticationHandler(wsfed.getName(), servicesManager, wsfedPrincipalFactory, wsfed.getOrder());
                if (wsfed.isAttributeResolverEnabled()) {
                    WsFederationConfiguration cfg = wsFederationConfigurations.toSet().stream().filter(c -> {
                        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
                        return c.getIdentityProviderUrl().equalsIgnoreCase(resolver.resolve(wsfed.getIdentityProviderUrl()));
                    }).findFirst().orElseThrow(() -> new RuntimeException("Unable to find configuration for identity provider " + wsfed.getIdentityProviderUrl()));
                    PersonDirectoryPrincipalResolverProperties principal = wsfed.getPrincipal();
                    WsFederationCredentialsToPrincipalResolver resolver = (WsFederationCredentialsToPrincipalResolver)CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)wsfedPrincipalFactory, (IPersonAttributeDao)attributeRepository, (IAttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), WsFederationCredentialsToPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
                    resolver.setConfiguration(cfg);
                    plan.registerAuthenticationHandlerWithPrincipalResolver((AuthenticationHandler)handler, (PrincipalResolver)resolver);
                } else {
                    plan.registerAuthenticationHandler((AuthenticationHandler)handler);
                }
            });
        }
    }

    @Configuration(value="WsFedAuthenticationEventExecutionPlanPrincipalConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WsFedAuthenticationEventExecutionPlanPrincipalConfiguration {
        @ConditionalOnMissingBean(name={"wsfedPrincipalFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalFactory wsfedPrincipalFactory() {
            return PrincipalFactoryUtils.newPrincipalFactory();
        }
    }

    @Configuration(value="WsFedAuthenticationProvidersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class WsFedAuthenticationProvidersConfiguration {
        private static WsFederationAttributeMutator getAttributeMutatorForWsFederationConfig(WsFederationDelegationProperties wsfed) {
            Resource location = wsfed.getAttributeMutatorScript().getLocation();
            if (location != null) {
                return new GroovyWsFederationAttributeMutator(location);
            }
            return WsFederationAttributeMutator.noOp();
        }

        private static WsFederationConfiguration getWsFederationConfiguration(WsFederationDelegationProperties wsfed, ConfigurableApplicationContext applicationContext) {
            SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
            WsFederationConfiguration config = new WsFederationConfiguration();
            config.setAttributesType(WsFederationConfiguration.WsFedPrincipalResolutionAttributesType.valueOf(wsfed.getAttributesType()));
            config.setIdentityAttribute(wsfed.getIdentityAttribute());
            String id = resolver.resolve(wsfed.getIdentityProviderIdentifier());
            config.setIdentityProviderIdentifier(id);
            String url = resolver.resolve(wsfed.getIdentityProviderUrl());
            config.setIdentityProviderUrl(url);
            String rpId = resolver.resolve(wsfed.getRelyingPartyIdentifier());
            config.setRelyingPartyIdentifier(rpId);
            String resources = resolver.resolve(wsfed.getSigningCertificateResources());
            config.setSigningCertificates(resources);
            StringUtils.commaDelimitedListToSet((String)wsfed.getEncryptionPrivateKey()).forEach(s -> config.setEncryptionPrivateKey(applicationContext.getResource(s)));
            StringUtils.commaDelimitedListToSet((String)wsfed.getEncryptionCertificate()).forEach(s -> config.setEncryptionCertificate(applicationContext.getResource(s)));
            config.setEncryptionPrivateKeyPassword(wsfed.getEncryptionPrivateKeyPassword());
            config.setAttributeMutator(WsFedAuthenticationProvidersConfiguration.getAttributeMutatorForWsFederationConfig(wsfed));
            config.setAutoRedirectType(wsfed.getAutoRedirectType());
            config.setName(wsfed.getName());
            config.setTolerance(Beans.newDuration((String)wsfed.getTolerance()).toMillis());
            config.setCookieGenerator(WsFedAuthenticationProvidersConfiguration.getCookieGeneratorForWsFederationConfig(wsfed, applicationContext));
            FunctionUtils.doIfNotNull((Object)wsfed.getId(), config::setId);
            return config;
        }

        private static CasCookieBuilder getCookieGeneratorForWsFederationConfig(WsFederationDelegationProperties wsfed, ConfigurableApplicationContext applicationContext) {
            WsFederationDelegatedCookieProperties cookie = wsfed.getCookie();
            CipherExecutor cipher = WsFedAuthenticationProvidersConfiguration.getCipherExecutorForWsFederationConfig(cookie);
            ObjectProvider geoLocationService = applicationContext.getBeanProvider(GeoLocationService.class);
            return new WsFederationCookieGenerator((CookieValueManager)new DefaultCasCookieValueManager(cipher, geoLocationService, DefaultCookieSameSitePolicy.INSTANCE, (PinnableCookieProperties)cookie), (CookieProperties)cookie);
        }

        private static CipherExecutor getCipherExecutorForWsFederationConfig(WsFederationDelegatedCookieProperties cookie) {
            return (CipherExecutor)FunctionUtils.doIf((boolean)cookie.getCrypto().isEnabled(), () -> CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)cookie.getCrypto(), WsFederationCookieCipherExecutor.class), () -> {
                LOGGER.info("WsFederation delegated authentication cookie encryption/signing is turned off and MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of delegated authentication cookie.");
                return CipherExecutor.noOp();
            }).get();
        }

        @ConditionalOnMissingBean(name={"wsFederationConfigurations"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<WsFederationConfiguration> wsFederationConfigurations(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            Set col = casProperties.getAuthn().getWsfed().stream().map(wsfed -> WsFedAuthenticationProvidersConfiguration.getWsFederationConfiguration(wsfed, applicationContext)).collect(Collectors.toSet());
            return BeanContainer.of(col);
        }
    }
}

