/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation;

import com.google.common.base.Predicates;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.authentication.crypto.WsFederationCertificateProvider;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredential;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.soap.wsfed.RequestSecurityTokenResponse;
import org.opensaml.soap.wsfed.RequestedSecurityToken;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsFederationHelper {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationHelper.class);
    private final OpenSamlConfigBean openSamlConfigBean;
    private final ServicesManager servicesManager;
    private Clock clock = Clock.systemUTC();

    private static Credential getEncryptionCredential(WsFederationConfiguration config) throws Exception {
        LOGGER.debug("Locating encryption credential private key [{}]", (Object)config.getEncryptionPrivateKey());
        BufferedReader br = new BufferedReader(new InputStreamReader(config.getEncryptionPrivateKey().getInputStream(), StandardCharsets.UTF_8));
        LOGGER.debug("Parsing credential private key");
        try (PEMParser pemParser = new PEMParser((Reader)br);){
            Object privateKeyPemObject = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)new BouncyCastleProvider());
            KeyPair kp = (KeyPair)FunctionUtils.doIf((Predicate)Predicates.instanceOf(PEMEncryptedKeyPair.class), (Supplier)Unchecked.supplier(() -> {
                LOGGER.debug("Encryption private key is an encrypted keypair");
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)privateKeyPemObject;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(config.getEncryptionPrivateKeyPassword().toCharArray());
                LOGGER.debug("Attempting to decrypt the encrypted keypair based on the provided encryption private key password");
                return converter.getKeyPair(ckp.decryptKeyPair(decProv));
            }), (Supplier)Unchecked.supplier(() -> {
                LOGGER.debug("Extracting a keypair from the private key");
                return converter.getKeyPair((PEMKeyPair)privateKeyPemObject);
            })).apply(privateKeyPemObject);
            X509CertParser certParser = new X509CertParser();
            LOGGER.debug("Locating encryption certificate [{}]", (Object)config.getEncryptionCertificate());
            certParser.engineInit(config.getEncryptionCertificate().getInputStream());
            LOGGER.debug("Invoking certificate engine to parse the certificate [{}]", (Object)config.getEncryptionCertificate());
            X509Certificate cert = (X509Certificate)certParser.engineRead();
            LOGGER.debug("Creating final credential based on the certificate [{}] and the private key", (Object)cert.getIssuerDN());
            BasicX509Credential basicX509Credential = new BasicX509Credential(cert, kp.getPrivate());
            return basicX509Credential;
        }
    }

    private static Decrypter buildAssertionDecrypter(WsFederationConfiguration config) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(new InlineEncryptedKeyResolver());
        list.add(new EncryptedElementTypeEncryptedKeyResolver());
        list.add(new SimpleRetrievalMethodEncryptedKeyResolver());
        LOGGER.trace("Built a list of encrypted key resolvers: [{}]", list);
        ChainingEncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(list);
        LOGGER.trace("Building credential instance to decrypt data");
        Credential encryptionCredential = WsFederationHelper.getEncryptionCredential(config);
        StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver(encryptionCredential);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)encryptedKeyResolver);
        decrypter.setRootInNewDocument(true);
        return decrypter;
    }

    public WsFederationCredential createCredentialFromToken(Assertion assertion) {
        ZonedDateTime retrievedOn = ZonedDateTime.now(this.clock);
        LOGGER.trace("Retrieved on [{}]", (Object)retrievedOn);
        WsFederationCredential credential = new WsFederationCredential();
        credential.setRetrievedOn(retrievedOn);
        credential.setId(assertion.getID());
        credential.setIssuer(assertion.getIssuer());
        credential.setIssuedOn(DateTimeUtils.zonedDateTimeOf((Instant)assertion.getIssueInstant()));
        Conditions conditions = assertion.getConditions();
        if (conditions != null) {
            credential.setNotBefore(DateTimeUtils.zonedDateTimeOf((Instant)conditions.getNotBefore()));
            credential.setNotOnOrAfter(DateTimeUtils.zonedDateTimeOf((Instant)conditions.getNotOnOrAfter()));
            if (!conditions.getAudienceRestrictionConditions().isEmpty()) {
                credential.setAudience(((Audience)((AudienceRestrictionCondition)conditions.getAudienceRestrictionConditions().getFirst()).getAudiences().getFirst()).getURI());
            }
        }
        if (!assertion.getAuthenticationStatements().isEmpty()) {
            credential.setAuthenticationMethod(((AuthenticationStatement)assertion.getAuthenticationStatements().getFirst()).getAuthenticationMethod());
        }
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        assertion.getAttributeStatements().stream().flatMap(attributeStatement -> attributeStatement.getAttributes().stream()).forEach(item -> {
            LOGGER.trace("Processed attribute: [{}]", (Object)item.getAttributeName());
            List itemList = item.getAttributeValues().stream().map(xmlObject -> ((XSAny)xmlObject).getTextContent()).collect(Collectors.toList());
            if (!itemList.isEmpty()) {
                attributes.put(item.getAttributeName(), itemList);
            }
        });
        credential.setAttributes(attributes);
        LOGGER.debug("WsFederation Credential retrieved as: [{}]", (Object)credential);
        return credential;
    }

    public RequestedSecurityToken getRequestSecurityTokenFromResult(String wresult) {
        RequestedSecurityToken requestedSecurityToken;
        LOGGER.debug("Result token received from ADFS is [{}]", (Object)wresult);
        ByteArrayInputStream in = new ByteArrayInputStream(wresult.getBytes(StandardCharsets.UTF_8));
        try {
            LOGGER.debug("Parsing token into a document");
            Document document = this.openSamlConfigBean.getParserPool().parse((InputStream)in);
            Element metadataRoot = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = this.openSamlConfigBean.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(metadataRoot);
            LOGGER.debug("Unmarshalling the document into a security token response");
            RequestSecurityTokenResponse rsToken = (RequestSecurityTokenResponse)unmarshaller.unmarshall(metadataRoot);
            LOGGER.debug("Locating list of requested security tokens");
            List rst = rsToken.getRequestedSecurityToken();
            LOGGER.debug("Locating the first occurrence of a requested security token in the list");
            requestedSecurityToken = (RequestedSecurityToken)rst.getFirst();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
                return null;
            }
        }
        in.close();
        return requestedSecurityToken;
    }

    public Pair<Assertion, WsFederationConfiguration> buildAndVerifyAssertion(RequestedSecurityToken reqToken, Collection<WsFederationConfiguration> config, Service service) {
        XMLObject securityToken = this.getSecurityTokenFromRequestedToken(reqToken, config);
        if (securityToken instanceof Assertion) {
            Assertion assertion = (Assertion)securityToken;
            LOGGER.debug("Extracted assertion successfully: [{}]", (Object)assertion);
            WsFederationConfiguration configuration = config.stream().filter(cfg -> StringUtils.isNotBlank((CharSequence)cfg.getIdentityProviderIdentifier())).filter(cfg -> {
                String id = cfg.getIdentityProviderIdentifier();
                LOGGER.trace("Comparing identity provider identifier [{}] with assertion issuer [{}]", (Object)id, (Object)assertion.getIssuer());
                return RegexUtils.find((String)id, (String)assertion.getIssuer());
            }).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not locate wsfed configuration for security token provided. The assertion issuer " + assertion.getIssuer() + " does not match any of the identity provider identifiers in the configuration"));
            return Pair.of((Object)assertion, (Object)configuration);
        }
        throw new IllegalArgumentException("Could not extract or decrypt an assertion based on the security token provided");
    }

    public XMLObject getAssertionFromSecurityToken(RequestedSecurityToken reqToken) {
        return (XMLObject)reqToken.getSecurityTokens().getFirst();
    }

    public boolean validateSignature(Pair<Assertion, WsFederationConfiguration> resultPair) {
        if (resultPair == null) {
            LOGGER.warn("No assertion or its configuration was provided to validate signatures");
            return false;
        }
        WsFederationConfiguration configuration = (WsFederationConfiguration)resultPair.getValue();
        Assertion assertion = (Assertion)resultPair.getKey();
        if (assertion == null || configuration == null) {
            LOGGER.warn("No signature or configuration was provided to validate signatures");
            return false;
        }
        Signature signature = assertion.getSignature();
        if (signature == null) {
            LOGGER.warn("No signature is attached to the assertion to validate");
            return false;
        }
        try {
            LOGGER.debug("Validating the signature...");
            SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
            validator.validate(signature);
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
            criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
            criteriaSet.add((Object)new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"));
            criteriaSet.add((Object)new EntityIdCriterion(configuration.getIdentityProviderIdentifier()));
            SignatureTrustEngine engine = this.buildSignatureTrustEngine(configuration);
            LOGGER.debug("Validating signature via trust engine for [{}]", (Object)configuration.getIdentityProviderIdentifier());
            return engine.validate((Object)signature, criteriaSet);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (String)"Failed to validate assertion signature", (Throwable)e);
            this.openSamlConfigBean.logObject((XMLObject)assertion);
            LOGGER.error("Signature doesn't match any signing credential and cannot be validated.");
            return false;
        }
    }

    public String getRelyingPartyIdentifier(Service service, WsFederationConfiguration configuration) {
        String relyingPartyIdentifier = configuration.getRelyingPartyIdentifier();
        if (service != null) {
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            if (RegisteredServiceProperty.RegisteredServiceProperties.WSFED_RELYING_PARTY_ID.isAssignedTo(registeredService)) {
                LOGGER.debug("Determined relying party identifier from service [{}] to be [{}]", (Object)service, (Object)relyingPartyIdentifier);
                RegisteredServiceProperty propertyValue = RegisteredServiceProperty.RegisteredServiceProperties.WSFED_RELYING_PARTY_ID.getPropertyValue(registeredService);
                return propertyValue != null ? propertyValue.value() : relyingPartyIdentifier;
            }
        }
        LOGGER.debug("Determined relying party identifier to be [{}]", (Object)relyingPartyIdentifier);
        return relyingPartyIdentifier;
    }

    private SignatureTrustEngine buildSignatureTrustEngine(WsFederationConfiguration wsFederationConfiguration) throws Exception {
        WsFederationCertificateProvider providers = WsFederationCertificateProvider.getProvider(wsFederationConfiguration, this.openSamlConfigBean);
        List<Credential> signingWallet = providers.getSigningCredentials();
        LOGGER.debug("Building signature trust engine based on the following signing certificates:");
        signingWallet.forEach(c -> LOGGER.debug("Credential entity id [{}] with public key [{}]", (Object)c.getEntityId(), (Object)c.getPublicKey()));
        StaticCredentialResolver resolver = new StaticCredentialResolver(signingWallet);
        StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver(signingWallet);
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)resolver, (KeyInfoCredentialResolver)keyResolver);
    }

    private XMLObject getSecurityTokenFromRequestedToken(RequestedSecurityToken reqToken, Collection<WsFederationConfiguration> config) {
        LOGGER.debug("Locating the first occurrence of a security token from the requested security token");
        XMLObject securityTokenFromAssertion = this.getAssertionFromSecurityToken(reqToken);
        Function func = FunctionUtils.doIf((Predicate)Predicates.instanceOf(EncryptedData.class), () -> {
            LOGGER.trace("Security token is encrypted. Attempting to decrypt to extract the assertion");
            EncryptedData encryptedData = (EncryptedData)securityTokenFromAssertion;
            Iterator it = config.iterator();
            while (it.hasNext()) {
                try {
                    WsFederationConfiguration c = (WsFederationConfiguration)it.next();
                    Decrypter decrypter = WsFederationHelper.buildAssertionDecrypter(c);
                    LOGGER.trace("Built an instance of [{}]", (Object)decrypter.getClass().getName());
                    return decrypter.decryptData(encryptedData);
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            LOGGER.error("Could not extract or decrypt an assertion based on the security token provided");
            return null;
        }, () -> securityTokenFromAssertion);
        return (XMLObject)func.apply(securityTokenFromAssertion);
    }

    @Generated
    public WsFederationHelper(OpenSamlConfigBean openSamlConfigBean, ServicesManager servicesManager) {
        this.openSamlConfigBean = openSamlConfigBean;
        this.servicesManager = servicesManager;
    }

    @Generated
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

