/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.authentication.crypto;

import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.authentication.crypto.ChainingWsFederationCertificateProvider;
import org.apereo.cas.support.wsfederation.authentication.crypto.WsFederationMetadataCertificateProvider;
import org.apereo.cas.support.wsfederation.authentication.crypto.WsFederationStaticCertificateProvider;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CertUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface WsFederationCertificateProvider {
    public static WsFederationCertificateProvider getProvider(WsFederationConfiguration config, OpenSamlConfigBean openSamlConfigBean) {
        ChainingWsFederationCertificateProvider chain = new ChainingWsFederationCertificateProvider();
        StringUtils.commaDelimitedListToSet((String)config.getSigningCertificates()).stream().map(Unchecked.function(ResourceUtils::getRawResourceFrom)).forEach(resource -> {
            if (StringUtils.hasText((String)resource.getFilename()) && resource.getFilename().endsWith(".xml")) {
                chain.addProvider(new WsFederationMetadataCertificateProvider((Resource)resource, config, openSamlConfigBean));
            } else {
                chain.addProvider(new WsFederationStaticCertificateProvider((Resource)resource));
            }
        });
        return chain;
    }

    public static Credential readCredential(InputStream is) throws Exception {
        CertificateFactory certificateFactory = CertUtils.getCertificateFactory();
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(is);
        return new BasicX509Credential(certificate);
    }

    public List<Credential> getSigningCredentials() throws Exception;
}

