/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.authentication.crypto;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.authentication.crypto.WsFederationCertificateProvider;
import org.apereo.cas.util.EncodingUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class WsFederationMetadataCertificateProvider
implements WsFederationCertificateProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationMetadataCertificateProvider.class);
    private final Resource metadataResource;
    private final WsFederationConfiguration configuration;
    private final OpenSamlConfigBean openSamlConfigBean;

    @Override
    public List<Credential> getSigningCredentials() throws Exception {
        try (InputStream is = this.metadataResource.getInputStream();){
            InMemoryResourceMetadataResolver resolver = new InMemoryResourceMetadataResolver(is, this.openSamlConfigBean);
            resolver.setId(UUID.randomUUID().toString());
            resolver.initialize();
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.configuration.getIdentityProviderIdentifier()), new EvaluableEntityRoleEntityDescriptorCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME)});
            LOGGER.debug("Locating entity descriptor in the metadata for [{}]", (Object)this.configuration.getIdentityProviderIdentifier());
            EntityDescriptor entityDescriptor = resolver.resolveSingle(criteria);
            List roleDescriptors = entityDescriptor.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            List signingDescriptors = ((RoleDescriptor)roleDescriptors.getFirst()).getKeyDescriptors().stream().filter(key -> key.getUse() == UsageType.SIGNING).collect(Collectors.toList());
            Collections.reverse(signingDescriptors);
            List<Credential> list = signingDescriptors.stream().map(KeyDescriptor::getKeyInfo).map(KeyInfo::getX509Datas).flatMap(Collection::stream).map(X509Data::getX509Certificates).flatMap(Collection::stream).map(Unchecked.function(cert -> {
                LOGGER.debug("Parsing signing certificate [{}]", (Object)cert.getValue());
                byte[] decode = EncodingUtils.decodeBase64((String)cert.getValue());
                try (ByteArrayInputStream value = new ByteArrayInputStream(decode);){
                    Credential credential = WsFederationCertificateProvider.readCredential(value);
                    return credential;
                }
            })).collect(Collectors.toList());
            return list;
        }
    }

    @Generated
    public WsFederationMetadataCertificateProvider(Resource metadataResource, WsFederationConfiguration configuration, OpenSamlConfigBean openSamlConfigBean) {
        this.metadataResource = metadataResource;
        this.configuration = configuration;
        this.openSamlConfigBean = openSamlConfigBean;
    }
}

