/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.authentication.handler.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.wsfederation.authentication.principal.WsFederationCredential;

public class WsFederationAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    public WsFederationAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    public boolean supports(Credential credentials) {
        return credentials != null && WsFederationCredential.class.isAssignableFrom(credentials.getClass());
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return WsFederationCredential.class.isAssignableFrom(clazz);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws Throwable {
        WsFederationCredential wsFederationCredentials = (WsFederationCredential)credential;
        if (wsFederationCredentials != null) {
            Map<String, List<Object>> attributes = wsFederationCredentials.getAttributes();
            Principal principal = this.principalFactory.createPrincipal(wsFederationCredentials.getId(), attributes);
            return this.createHandlerResult((Credential)wsFederationCredentials, principal, new ArrayList(0));
        }
        throw new FailedLoginException();
    }
}

