/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.web.WsFederationServerStateSerializer;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class WsFederationCookieManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WsFederationCookieManager.class);
    public static final String WCTX = "wctx";
    private final Collection<WsFederationConfiguration> configurations;
    private final CasConfigurationProperties casProperties;
    private final WsFederationServerStateSerializer serializer = new WsFederationServerStateSerializer();

    public Service retrieve(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String contextId = request.getParameter(WCTX);
        LOGGER.debug("Parameter [{}] received: [{}]", (Object)WCTX, (Object)contextId);
        if (StringUtils.isBlank((CharSequence)contextId)) {
            LOGGER.error("No [{}] parameter is found", (Object)WCTX);
            throw new IllegalArgumentException("No wctx parameter is found");
        }
        WsFederationConfiguration configuration = this.configurations.stream().filter(cookie -> cookie.getId().equalsIgnoreCase(contextId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not locate WsFederation configuration for " + contextId));
        CasCookieBuilder cookieGen = configuration.getCookieGenerator();
        String serverState = cookieGen.retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)serverState)) {
            serverState = Optional.ofNullable(request.getSession(false)).map(session -> session.getAttribute(configuration.getId())).map(String.class::cast).orElse(null);
        }
        if (StringUtils.isBlank((CharSequence)serverState)) {
            LOGGER.error("No server state value could be retrieved to determine the state of the delegated authentication session");
            throw new IllegalArgumentException("No state could be found to determine session state");
        }
        String blob = EncodingUtils.hexDecode((String)serverState);
        Map session2 = (Map)this.serializer.from(blob);
        request.setAttribute(this.casProperties.getTheme().getParamName(), session2.get(this.casProperties.getTheme().getParamName()));
        request.setAttribute(this.casProperties.getLocale().getParamName(), session2.get(this.casProperties.getLocale().getParamName()));
        request.setAttribute("method", session2.get("method"));
        String serviceKey = "service-" + contextId;
        Service service = (Service)session2.get(serviceKey);
        LOGGER.debug("Located service [{}] from session", (Object)service);
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        return service;
    }

    public void store(HttpServletRequest request, HttpServletResponse response, String wctx, Service service, WsFederationConfiguration configuration) {
        Object theme;
        Object locale;
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("service-" + wctx, service);
        String methods = request.getParameter("method");
        if (StringUtils.isNotBlank((CharSequence)methods)) {
            details.put("method-" + wctx, methods);
        }
        if ((locale = request.getAttribute(this.casProperties.getLocale().getParamName())) != null) {
            details.put(this.casProperties.getLocale().getParamName() + "-" + wctx, locale);
        }
        if ((theme = request.getAttribute(this.casProperties.getTheme().getParamName())) != null) {
            details.put(this.casProperties.getTheme().getParamName() + "-" + wctx, theme);
        }
        String cookieValue = this.serializeSessionValues(details);
        CasCookieBuilder cookieGen = configuration.getCookieGenerator();
        LOGGER.debug("Adding WsFederation cookie [{}] with value [{}]", (Object)cookieGen.getCookieName(), (Object)cookieValue);
        cookieGen.addCookie(request, response, cookieValue);
        Optional.ofNullable(request.getSession(false)).ifPresent(session -> session.setAttribute(configuration.getId(), (Object)cookieValue));
    }

    private String serializeSessionValues(Map<String, Object> attributes) {
        String blob = this.serializer.toString(attributes);
        return EncodingUtils.hexEncode((String)blob);
    }

    @Generated
    public WsFederationCookieManager(Collection<WsFederationConfiguration> configurations, CasConfigurationProperties casProperties) {
        this.configurations = configurations;
        this.casProperties = casProperties;
    }
}

