/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.wsfederation.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.wsfederation.WsFederationConfiguration;
import org.apereo.cas.support.wsfederation.WsFederationHelper;
import org.apereo.cas.support.wsfederation.web.WsFederationCookieManager;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="wsFederationNavigationController")
@RequestMapping
public class WsFederationNavigationController {
    public static final String ENDPOINT_REDIRECT = "/wsfedredirect";
    public static final String PARAMETER_NAME = "wsfedclientid";
    private final WsFederationCookieManager wsFederationCookieManager;
    private final WsFederationHelper wsFederationHelper;
    private final Collection<WsFederationConfiguration> configurations;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final String casLoginEndpoint;
    private final ArgumentExtractor argumentExtractor;

    @GetMapping(value={"/wsfedredirect"})
    public View redirectToProvider(HttpServletRequest request, HttpServletResponse response) {
        String wsfedId = request.getParameter(PARAMETER_NAME);
        WsFederationConfiguration cfg = this.configurations.stream().filter(c -> c.getId().equals(wsfedId)).findFirst().orElseThrow(() -> UnauthorizedServiceException.denied((String)"Could not locate WsFederation configuration for %s".formatted(wsfedId)));
        Service service = this.determineService(request);
        String id = this.wsFederationHelper.getRelyingPartyIdentifier(service, cfg);
        String url = cfg.getAuthorizationUrl(id, cfg.getId());
        this.wsFederationCookieManager.store(request, response, cfg.getId(), service, cfg);
        return new RedirectView(url);
    }

    protected Service determineService(HttpServletRequest request) {
        return (Service)ObjectUtils.defaultIfNull((Object)this.argumentExtractor.extractService(request), (Object)((WebApplicationService)this.webApplicationServiceFactory.createService(this.casLoginEndpoint)));
    }

    @Generated
    public WsFederationNavigationController(WsFederationCookieManager wsFederationCookieManager, WsFederationHelper wsFederationHelper, Collection<WsFederationConfiguration> configurations, ServiceFactory<WebApplicationService> webApplicationServiceFactory, String casLoginEndpoint, ArgumentExtractor argumentExtractor) {
        this.wsFederationCookieManager = wsFederationCookieManager;
        this.wsFederationHelper = wsFederationHelper;
        this.configurations = configurations;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.casLoginEndpoint = casLoginEndpoint;
        this.argumentExtractor = argumentExtractor;
    }
}

