/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication;

import java.security.GeneralSecurityException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;

public class ExpiredCRLException
extends GeneralSecurityException {
    private static final long serialVersionUID = 5157864033250359972L;
    private final String id;
    private final ZonedDateTime expirationDate;
    private final int leniency;

    public ExpiredCRLException(String identifier, ZonedDateTime expirationDate) {
        this(identifier, expirationDate, 0);
    }

    public ExpiredCRLException(String identifier, ChronoZonedDateTime expirationDate, int leniency) {
        this.id = identifier;
        this.expirationDate = (ZonedDateTime)expirationDate;
        if (leniency < 0) {
            throw new IllegalArgumentException("Leniency is negative.");
        }
        this.leniency = leniency;
    }

    public ExpiredCRLException(String identifier, ZonedDateTime expirationDate, int leniency) {
        this.id = identifier;
        this.expirationDate = ZonedDateTime.from(expirationDate);
        if (leniency < 0) {
            throw new IllegalArgumentException("Leniency must not be negative.");
        }
        this.leniency = leniency;
    }

    public ExpiredCRLException(String identifier, Instant expirationDate, int leniency) {
        this.id = identifier;
        this.expirationDate = ZonedDateTime.ofInstant(expirationDate, ZoneOffset.UTC);
        if (leniency < 0) {
            throw new IllegalArgumentException("Leniency cannot be negative.");
        }
        this.leniency = leniency;
    }

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getExpirationDate() {
        return this.expirationDate == null ? null : ZonedDateTime.from(this.expirationDate);
    }

    public int getLeniency() {
        return this.leniency;
    }

    @Override
    public String getMessage() {
        if (this.leniency > 0) {
            return String.format("CRL %s expired on %s and is beyond the leniency period of %s seconds.", this.id, this.expirationDate, this.leniency);
        }
        return String.format("CRL %s expired on %s", this.id, this.expirationDate);
    }
}

