/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.util.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ResourceCRLFetcher
implements CRLFetcher {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Set<X509CRL> fetch(Set<Resource> crls) throws IOException, CRLException, CertificateException {
        HashSet<X509CRL> results = new HashSet<X509CRL>();
        for (Resource r : crls) {
            this.logger.debug("Fetching CRL data from {}", (Object)r);
            InputStream ins = r.getInputStream();
            Throwable throwable = null;
            try {
                X509CRL crl = (X509CRL)CertUtils.getCertificateFactory().generateCRL(ins);
                if (crl == null) continue;
                results.add(crl);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ins == null) continue;
                if (throwable != null) {
                    try {
                        ins.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ins.close();
            }
        }
        return results;
    }

    @Override
    public X509CRL fetch(String crl) throws IOException, CRLException, CertificateException {
        return this.fetch(new URL(crl));
    }

    @Override
    public X509CRL fetch(Resource crl) throws IOException, CRLException, CertificateException {
        Set<X509CRL> results = this.fetch(Collections.singleton(crl));
        if (!results.isEmpty()) {
            return results.iterator().next();
        }
        this.logger.warn("Unable to fetch {}", (Object)crl);
        return null;
    }

    @Override
    public X509CRL fetch(URI crl) throws IOException, CRLException, CertificateException {
        return this.fetch(crl.toURL());
    }

    @Override
    public X509CRL fetch(URL crl) throws IOException, CRLException, CertificateException {
        return this.fetch((Resource)new UrlResource(crl));
    }
}

