/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.ldap;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.LdapUtils;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchResult;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class LdaptiveResourceCRLFetcher
extends ResourceCRLFetcher {
    protected SearchExecutor searchExecutor;
    protected ConnectionConfig connectionConfig;

    public LdaptiveResourceCRLFetcher() {
    }

    public LdaptiveResourceCRLFetcher(ConnectionConfig connectionConfig, SearchExecutor searchExecutor) {
        this.connectionConfig = connectionConfig;
        this.searchExecutor = searchExecutor;
    }

    @Override
    public X509CRL fetch(Resource crl) throws IOException, CRLException, CertificateException {
        if (LdapUtils.isLdapConnectionUrl((String)crl.toString())) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    @Override
    public X509CRL fetch(URI crl) throws IOException, CRLException, CertificateException {
        if (LdapUtils.isLdapConnectionUrl((URI)crl)) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    @Override
    public X509CRL fetch(URL crl) throws IOException, CRLException, CertificateException {
        if (LdapUtils.isLdapConnectionUrl((URL)crl)) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    @Override
    public X509CRL fetch(String crl) throws IOException, CRLException, CertificateException {
        if (LdapUtils.isLdapConnectionUrl((String)crl)) {
            return this.fetchCRLFromLdap(crl);
        }
        return super.fetch(crl);
    }

    protected X509CRL fetchCRLFromLdap(Object r) throws CertificateException, IOException, CRLException {
        try {
            String ldapURL = r.toString();
            this.logger.debug("Fetching CRL from ldap {}", (Object)ldapURL);
            Response<SearchResult> result = this.performLdapSearch(ldapURL);
            if (result.getResultCode() == ResultCode.SUCCESS) {
                LdapEntry entry = ((SearchResult)result.getResult()).getEntry();
                LdapAttribute attribute = entry.getAttribute();
                this.logger.debug("Located entry [{}]. Retrieving first attribute [{}]", (Object)entry, (Object)attribute);
                return this.fetchX509CRLFromAttribute(attribute);
            }
            this.logger.debug("Failed to execute the search [{}]", result);
            throw new CertificateException("Failed to establish a connection ldap and search.");
        }
        catch (LdapException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new CertificateException(e.getMessage());
        }
    }

    protected X509CRL fetchX509CRLFromAttribute(LdapAttribute aval) throws CertificateException, IOException, CRLException {
        if (aval != null) {
            byte[] val = aval.getBinaryValue();
            if (val == null || val.length == 0) {
                throw new CertificateException("Empty attribute. Can not download CRL from ldap");
            }
            byte[] decoded64 = EncodingUtils.decodeBase64((byte[])val);
            if (decoded64 == null) {
                throw new CertificateException("Could not decode the attribute value to base64");
            }
            this.logger.debug("Retrieved CRL from ldap as byte array decoded in base64. Fetching...");
            return super.fetch((Resource)new ByteArrayResource(decoded64));
        }
        throw new CertificateException("Attribute not found. Can not retrieve CRL");
    }

    protected Response<SearchResult> performLdapSearch(String ldapURL) throws LdapException {
        ConnectionFactory connectionFactory = this.prepareConnectionFactory(ldapURL);
        return this.searchExecutor.search(connectionFactory);
    }

    protected ConnectionFactory prepareConnectionFactory(String ldapURL) {
        ConnectionConfig cc = ConnectionConfig.newConnectionConfig((ConnectionConfig)this.connectionConfig);
        cc.setLdapUrl(ldapURL);
        return new DefaultConnectionFactory(cc);
    }

    public void setSearchExecutor(SearchExecutor searchExecutor) {
        this.searchExecutor = searchExecutor;
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }
}

