/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apereo.cas.adaptors.x509.util.CertUtils;
import org.apereo.cas.adaptors.x509.util.X509CertificateCredentialJsonDeserializer;
import org.apereo.cas.adaptors.x509.util.X509CertificateCredentialJsonSerializer;
import org.apereo.cas.authentication.AbstractCredential;

@JsonSerialize(using=X509CertificateCredentialJsonSerializer.class)
@JsonDeserialize(using=X509CertificateCredentialJsonDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public class X509CertificateCredential
extends AbstractCredential {
    private static final long serialVersionUID = 631753409512746474L;
    private X509Certificate[] certificates;
    private X509Certificate certificate;

    public X509CertificateCredential(X509Certificate[] certificates) {
        this.certificates = Arrays.copyOf(certificates, certificates.length);
    }

    public X509Certificate[] getCertificates() {
        return Arrays.copyOf(this.certificates, this.certificates.length);
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getId() {
        X509Certificate cert = null;
        if (this.certificate != null) {
            cert = this.certificate;
        } else if (this.certificates.length > 0) {
            cert = this.certificates[0];
        }
        if (cert != null) {
            return CertUtils.toString(cert);
        }
        return "unknown";
    }
}

