/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;

public class X509SerialNumberAndIssuerDNPrincipalResolver
extends AbstractX509PrincipalResolver {
    private String serialNumberPrefix = "SERIALNUMBER=";
    private String valueDelimiter = ", ";

    public void setSerialNumberPrefix(String serialNumberPrefix) {
        this.serialNumberPrefix = serialNumberPrefix;
    }

    public void setValueDelimiter(String valueDelimiter) {
        this.valueDelimiter = valueDelimiter;
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        StringBuilder builder = new StringBuilder(this.serialNumberPrefix);
        builder.append(certificate.getSerialNumber());
        builder.append(this.valueDelimiter);
        builder.append(certificate.getIssuerDN().getName());
        return builder.toString();
    }
}

